import tkinter
from tkinter import *
from tkinter import ttk
from tkinter.filedialog import *
import platform
from get_file import *
from BSL_pack import *
from UART_send import *
from generate_linker import *
import time
import os
from txt_to_h import *



class Tkinter_app():
    def __init__(self, master):
        self.passwordfile = b''
        self.App_addr_start = ''
        self.App_addr_end = ''
        self.range_erase_pack = b''
        self.app_flag = ''
        self.firmwaredfile = []
        self.xds_v = tkinter.StringVar(None, 'a')
        self.app_add_flag = ''
        self.app_add_flag2 = ''

        self.device_var = 'MSPM0L1xxx'

        self.D_iomux_max = 200
        self.D_BSLIVK_PAD_NUM_var = '40'
        self.D_BSLIVK_GPIOPIN_var = '18'

        # self.D_BSLPINCFG0_var = '0x02180217'
        self.D_UARTTX_MUX_SEL_var = '02'
        self.D_UARTTX_PAD_NUM_var = '24'
        self.D_UARTRX_MUX_SEL_var = '02'
        self.D_UARTRX_PAD_NUM_var = '23'

        # self.D_BSLPINCFG1_var = '0x03020301'
        self.D_I2CSCL_MUX_SEL_var = '02'
        self.D_I2CSCL_PAD_NUM_var = '02'
        self.D_I2CSDA_MUX_SEL_var = '03'
        self.D_I2CSDA_PAD_NUM_var = '01'

        self.BCRCONFIGID_var = '0x00000001'

        self.BOOTCFG0_var = '0xAABBAABB'
        self.BOOTCFG0_var1 = 'enabled'
        self.BOOTCFG0_var2 = 'enabled'

        self.SWDPW_S_0 = '0xFFFFFFFF'
        self.SWDPW_S_1 = '0xFFFFFFFF'
        self.SWDPW_S_2 = '0xFFFFFFFF'
        self.SWDPW_S_3 = '0xFFFFFFFF'

        self.BOOTCFG1_var = '0xAABBAABB'
        self.BOOTCFG1_var1 = 'enabled'
        self.BOOTCFG1_var2 = 'enabled'

        self.BOOTCFG2_var = '0xAABBFFFF'
        self.BOOTCFG2_var1 = 'enabled'
        self.BOOTCFG2_var2 = 'disabled'

        self.MEPW_S_0 = '0xFFFFFFFF'
        self.MEPW_S_1 = '0xFFFFFFFF'
        self.MEPW_S_2 = '0xFFFFFFFF'
        self.MEPW_S_3 = '0xFFFFFFFF'

        self.FRPW_S_0 = '0xFFFFFFFF'
        self.FRPW_S_1 = '0xFFFFFFFF'
        self.FRPW_S_2 = '0xFFFFFFFF'
        self.FRPW_S_3 = '0xFFFFFFFF'

        self.FLASHSWP0_var = '0xFFFFFFFF'

        self.FLASHSWP1_var = '0xFFFFFFFF'

        self.BOOTCFG3_var = '0xAABBAABB'
        self.BOOTCFG3_var1 = 'enabled'
        self.BOOTCFG3_var2 = 'enabled'

        self.BOOTCFG4_var = '0xFFFFFFFF'
        self.BOOTCFG4_var1 = 'disabled'
        self.BOOTCFG4_var2 = 'unlocked'

        self.APPCRCSTART_var = '0xFFFFFFFF'

        self.APPCRCLEN_var = '0xFFFFFFFF'

        self.APPCRC_var = '0xFFFFFFFF'

        self.BSLID_var = '0x00000001'

        self.BSLPINCFG0_var = '0x02180217'
        self.BSLPINCFG0_var1 = '02'
        self.BSLPINCFG0_var2 = '24'
        self.BSLPINCFG0_var3 = '02'
        self.BSLPINCFG0_var4 = '23'

        self.BSLPINCFG1_var = '0x03020301'
        self.BSLPINCFG1_var1 = '03'
        self.BSLPINCFG1_var2 = '02'
        self.BSLPINCFG1_var3 = '03'
        self.BSLPINCFG1_var4 = '01'

        self.BSLCFG_var = '0xFFFF1293'
        self.BSLCFG_var1 = 'disabled'
        self.BSLCFG_var2 = 'PA'
        self.BSLCFG_var3 = '18'
        self.BSLCFG_var4 = 'high'
        self.BSLCFG_var5 = '19'

        self.BSLPW_S_0 = '0xFFFFFFFF'
        self.BSLPW_S_1 = '0xFFFFFFFF'
        self.BSLPW_S_2 = '0xFFFFFFFF'
        self.BSLPW_S_3 = '0xFFFFFFFF'
        self.BSLPW_S_4 = '0xFFFFFFFF'
        self.BSLPW_S_5 = '0xFFFFFFFF'
        self.BSLPW_S_6 = '0xFFFFFFFF'
        self.BSLPW_S_7 = '0xFFFFFFFF'

        self.BSLPLUGINCFG_var = '0xFFFFFFFF'
        self.BSLPLUGINCFG_var1 = 'not exist'
        self.BSLPLUGINCFG_var2 = 'none'
        self.BSLPLUGINCFG_var3 = '255'

        self.PLUGIN_INIT = '0xFFFFFFFF'
        self.PLUGIN_RECEIVE = '0xFFFFFFFF'
        self.PLUGIN_TRANSMIT = '0xFFFFFFFF'
        self.PLUGIN_DEINIT = '0xFFFFFFFF'

        self.BSLALTCFG_var = '0xFFFFFFFF'
        self.BSLALTCFG_var1 = 'not use'

        self.BSLALTADDR_var = '0xFFFFFFFF'

        self.BSLAPPVER_var = '0xFFFFFFFF'

        self.BSLSECCFG_var = '0x0048FFFF'
        self.BSLSECCFG_var1 = 'ignore'
        self.BSLSECCFG_var2 = '72'

        self.version_var = 'v1'
        # self.xds_r = tkinter.StringVar(None, '1')
        menubar = Menu(master, tearoff=0)
#        menubar.add_command(label='MoreOption')
        menufile = Menu(menubar, tearoff=0)
        menubar.add_cascade(label='MoreOption', menu=menufile)
        menufile.add_command(label='Create Linker Files', command=self.create_linker)
        menufile.add_command(label='Create non-main flash txt firmware', command=self.create_non_main_txt)
        master['menu'] = menubar

        # menubar.config(bg='red')
     #   menubar.pack()

        # variable = StringVar(master)
        # variable.set("one")  # default value
        # w = OptionMenu(master, variable, "one", "two", "three")
        # w.config(bg="gray")  # Set background color to green
        # w.pack()


        frame6 = Frame(master)
        frame6.configure(bg='#A8B680')
        frame6.pack(padx=45, anchor=E)

        frame0 = Frame(master)
        frame0.configure(bg='#A8B680')
        frame0.pack(padx=50, pady=20, anchor=E)
        frame1 = Frame(master)
        frame1.configure(bg='#A8B680')
        frame1.pack(padx=50, anchor=E)
        frame3 = Frame(master)
        frame3.configure(bg='#A8B680')
        frame3.pack(pady=10, fill=X)
        frame4 = Frame(master)
        frame4.pack()
        frame5 = Frame(master)
        frame5.pack()
        # frame6 = Frame(master)
        # frame6.pack(padx=1, pady=20, anchor=E)
        frame2 = Frame(master)
        frame2.pack(side='bottom')


        self.label6 = Label(frame6, text='Do it before choose Application firmware:', background = '#A8B680')
        self.label6.pack(side='left', padx=5)
        self.button6 = Button(frame6, text='Check Application satus', command=self.Check_app)
        self.button6.pack(side='left', padx=5)

        self.label0 = Label(frame0, text='Application firmware file:',background = '#A8B680')
        self.label0.pack(side='left')
        global input_name
        input_name = StringVar()
        self.entry = Entry(frame0, width=50, textvariable=input_name)
        self.entry.pack(side='left')
        self.button = Button(frame0, text='Choose .txt file', command=self.choosefile)
        self.button.pack(side='left')

        self.label1 = Label(frame1, text='Password file:',background = '#A8B680')
        self.label1.pack(side='left')
        global input_name1
        input_name1 = StringVar()
        self.entry1 = Entry(frame1, width=50, textvariable=input_name1)
        self.entry1.pack(side='left')
        self.button1 = Button(frame1, text='Choose .txt file', command=self.choosefile1)
        self.button1.pack(side='left')


        global photo
#        photo = PhotoImage(file=SETUP_DIR + "\imag\oi.GIF")
        photo = PhotoImage(file="imag\oi.GIF")
        self.label2 = Label(frame2, image=photo)
        self.label2.pack()

        self.button = Button(frame3, text='Download', command=self.download)
        self.button.pack()

        self.label3 = Label(frame3, text='(Download: Just support UART with XDS110)',background = '#A8B680')
        self.label3.pack()

        # self.rad_button = Radiobutton(frame3, text='XDS110 on Launchpad', variable=self.xds_v, value='a', command=self.xds110_LP)
        # self.rad_button.place(relx=0.7,rely=0)
        # self.rad_button2 = Radiobutton(frame3, text='Standalone XDS110', variable=self.xds_v, value='b', command=self.xds110_S)
        # self.rad_button2.place(relx=0.7,rely=0.5)

        # self.rad_button3 = Radiobutton(frame3, text='BOOTRST', variable=self.xds_r, value='1', command=self.xds110_BR)
        # self.rad_button3.place(relx=0.1,rely=0)
        # self.rad_button4 = Radiobutton(frame3, text='POR', variable=self.xds_r, value='2', command=self.xds110_PR)
        # self.rad_button4.place(relx=0.1,rely=0.5)

        self.s1 = Scrollbar(frame4)
        self.s1.pack(side=RIGHT, fill=Y)
        self.textlog = Text(frame4, yscrollcommand=self.s1.set, width=70, height=15, bg='white')
        self.s1.config(command=self.textlog.yview)
        self.textlog.pack()

        self.textlog.insert(INSERT, 'This GUI is developed with Python version: 3.10.4\n')
        self.textlog.insert(INSERT, 'Default hardware is XDS110 on Launchpad.\n')
        # self.textlog.insert(INSERT, 'Default reset type is boot reset.\n')
#        self.textlog.insert(INSERT, "Python version: "+platform.python_version() + '\n')
        self.textlog.tag_config('error', foreground='red')
        self.textlog.tag_config('pass', foreground='green')
        self.textlog.tag_config('normal', foreground='black')
        self.textlog.config(state=DISABLED)

        self.button_c = Button(frame5, text='Clear', command=self.clear_text)
        self.button_c.pack()

        self.connection_pack = BSL_pack.connection_pack()
        self.get_ID_pack = BSL_pack.get_ID_pack()
        self.password_pack = b''
        self.firmware_pack = b''
        self.start_app_pack = BSL_pack.start_app_pack()
        self.path = os.getcwd()


    def Check_app(self):
        self.textlog.config(state=NORMAL)
        find_flag = UART_S.find_MSP_COM()
        if find_flag:
            self.textlog.insert(INSERT, 'Find MSP COM port:' + find_flag + '\n', 'normal')
            ser_port = UART_S.config_uart(find_flag)
            self.textlog.insert(INSERT,
                                'Configure UART: 9600 baudrate, 8 data bits (LSB first), no parity, and 1 stop bit.\n',
                                'normal')
            self.textlog.insert(INSERT, 'Get application running status.\n', 'normal')
            UART_S.send_data(ser_port, b'\x55')
            self.app_flag = UART_S.read_data(ser_port, 8)
            self.app_add_flag = '0x' + self.app_flag[5:10]
            self.app_add_flag2 = '0x' + self.app_flag[11:16]
            self.app_add_flag3 = self.app_flag[0:2]
            # print(self.app_add_flag3)
            if self.app_add_flag3 == '51':
                if self.app_flag[2:4] == '01':
                    self.textlog.insert(INSERT, 'App1(Location at: 0x' + self.app_flag[5:10] + ' ~ 0x' + self.app_flag[11:16] +
                                        ') is running, please choose a      App2(Start from 0x'+ self.app_flag[11:16] +') firmware to download.\n', 'normal')
                else:
                    if self.app_flag[2:4] == '02':
                        self.textlog.insert(INSERT, 'App2(Start from: 0x' + self.app_flag[11:16] +
                                            ' to flash end)  is running,   please choose a App1(Start from 0x'+ self.app_flag[5:10] +') firmware to download.\n', 'normal')
                    else:
                        self.textlog.insert(INSERT, 'No App is running.\n', 'normal')
            else:
                self.textlog.insert(INSERT, 'Error: No UART data received, please check the UART connection!\n', 'error')
        else:
            self.textlog.insert(INSERT, 'Error: Can not find MSP COM port!\n', 'error')
        self.textlog.see(END)
        self.textlog.config(state=DISABLED)
    def xds110_BR(self):
        self.textlog.config(state=NORMAL)
        self.textlog.insert(INSERT, 'Changed reset type to boot reset.\n', 'normal')
        self.textlog.config(state=DISABLED)
    def xds110_PR(self):
        self.textlog.config(state=NORMAL)
        self.textlog.insert(INSERT, 'Changed reset type to power on reset.\n', 'normal')
        self.textlog.config(state=DISABLED)
    def choosefile(self):
        self.textlog.config(state=NORMAL)
        if self.app_flag != '':
            f = askopenfilename(title='Choose a firmware file', initialdir='c:', filetypes=[("textfile",".txt")])
            input_name.set(f)
            if f:
                self.textlog.insert(INSERT, 'Choose a firmware file at:' + f + '\n', 'normal')
                self.firmwaredfile = file_d.get_firmware(f)

                self.App_addr_start = file_d.get_app_start(self.firmwaredfile)
                if self.app_flag[2:4] == '01':
                    if int(self.app_add_flag2, 16) != int(self.App_addr_start, 16):
                        self.textlog.insert(INSERT, 'Error: Start address not from ' + self.app_add_flag2 + '.\n', 'error')
                        self.firmwaredfile = []
                else:
                    if self.app_flag[2:4] == '02':
                        if int(self.app_add_flag, 16) != int(self.App_addr_start, 16):
                            self.textlog.insert(INSERT, 'Error: Start address not from ' + self.app_add_flag + '.\n', 'error')
                            self.firmwaredfile = []
                if self.firmwaredfile != []:
                    self.App_addr_end = file_d.get_app_end(self.firmwaredfile)
                    self.range_erase_pack = BSL_pack.range_erase_pack(self.App_addr_start, self.App_addr_end)
                    self.firmware_pack = BSL_pack.firmware_pack(self.firmwaredfile)
                    self.app_flag = ''
            else:
                self.textlog.insert(INSERT, 'Error: Please choose a firmware file.\n', 'error')
                self.firmwaredfile = []
                self.firmware_pack = b''

        else:
            self.textlog.insert(INSERT, 'Error: Please check the app status first.\n', 'error')
        self.textlog.see(END)
        self.textlog.config(state=DISABLED)

    def choosefile1(self):
        self.textlog.config(state=NORMAL)
        f1 = askopenfilename(title='Choose a password file', initialdir='c:', filetypes=[("textfile",".txt")])
        input_name1.set(f1)
        if f1:
            self.textlog.insert(INSERT, 'Choose a password file at:' + f1 + '\n', 'normal')
            self.passwordfile = b''
            self.passwordfile = file_d.get_password(f1)
            self.password_pack = BSL_pack.password_pack(self.passwordfile)
        else:
            self.passwordfile = b''
            self.textlog.insert(INSERT, 'Error: Please choose a password file.\n', 'error')
        if self.passwordfile == b'':
            self.textlog.insert(INSERT, 'Error: Password format is not correct!\n', 'error')
        # else:
        #     print(self.passwordfile)
        self.textlog.see(END)
        self.textlog.config(state=DISABLED)

    def download(self):
        self.textlog.config(state=NORMAL)
        if self.password_pack != b'' and self.firmwaredfile != []:
            find_flag = UART_S.find_MSP_COM()
            if find_flag:
                self.textlog.insert(INSERT, 'Find MSP COM port:' + find_flag + '\n', 'normal')
                ser_port = UART_S.config_uart(find_flag)
                self.textlog.insert(INSERT, 'Configure UART: 9600 baudrate, 8 data bits (LSB first), no parity, and 1 stop bit.\n', 'normal')

                UART_S.send_data(ser_port, b'\x11')
                response01 = UART_S.read_data(ser_port, 1)
#                print(response)
                if response01 == '51':
                    self.textlog.insert(INSERT, 'Bootloader is running.\n', 'normal')
                    self.textlog.insert(INSERT, 'Send the password...\n', 'normal')
                    UART_S.send_data(ser_port, self.password_pack)
                    response2 = UART_S.read_data(ser_port, 1)
                    check = self.check_pack(response2)
                    if check:
                        response2 = UART_S.read_data(ser_port, 9)
                        check2 = self.check_reponse(response2[8:10])
                        # print(response2[8:10])
                        if check2:
                            self.textlog.insert(INSERT, 'Erase application area:'+self.App_addr_start + ' to ' + self.App_addr_end+ '\n', 'normal')
                            UART_S.send_data(ser_port, self.range_erase_pack)
                            response2 = UART_S.read_data(ser_port, 1)
                            check = self.check_pack(response2)
                            response2 = UART_S.read_data(ser_port, 9)
                            check2 = self.check_reponse(response2[8:10])
                            if check2:
                                self.textlog.insert(INSERT, 'Send the firmware...\n', 'normal')
                                # print(type(firmware_pack))
                                # print(firmware_pack)
                                for list_code in self.firmware_pack:
                                    UART_S.send_data(ser_port, list_code)
                                    response3 = UART_S.read_data(ser_port, 1)
                                    check = self.check_pack(response3)
                                    if check:
                                        response3 = UART_S.read_data(ser_port, 9)
                                        check3 = self.check_reponse(response3[8:10])
                                        if check3:pass
                                        else: break
                                    else: break
                                if check:
                                    self.textlog.insert(INSERT, 'Send firmware successfully!\n', 'normal')
                                    self.textlog.insert(INSERT, 'Boot reset the device to start application ...\n', 'normal')
                                    self.textlog.insert(INSERT, '-----------Download finished!----------\n', 'pass')
                                    UART_S.send_data(ser_port, self.start_app_pack)
                                    response3 = UART_S.read_data(ser_port, 1)
                                    self.firmwaredfile = []
                                    self.entry.delete(0, 'end')
                    else:
                        self.textlog.insert(INSERT, 'Error: No response！01\n', 'error')
                else:
                    if response01 == '22':
                        self.textlog.insert(INSERT, 'Bootloader is not run, please trigger the bootloader first.\n', 'normal')
                        self.textlog.insert(INSERT, 'Send commend to wakeup the bootloader(Send 0xAA).\n', 'normal')
                        UART_S.send_data(ser_port, b'\xAA')
                        response01 = UART_S.read_data(ser_port, 1)
                        if response01 == 'bb':
                            self.textlog.insert(INSERT, 'Send 0xAA successfully.\n', 'normal')
                            time.sleep(0.5)
                            UART_S.send_data(ser_port, b'\x11')
                            response01 = UART_S.read_data(ser_port, 1)
                            if response01 == '51':
                                self.textlog.insert(INSERT, 'Bootloader is running.\n', 'normal')
                                self.textlog.insert(INSERT, 'Send the password...\n', 'normal')
                                UART_S.send_data(ser_port, self.password_pack)
                                response2 = UART_S.read_data(ser_port, 1)
                                check = self.check_pack(response2)
                                if check:
                                    response2 = UART_S.read_data(ser_port, 9)
                                    check2 = self.check_reponse(response2[8:10])
                                    # print(response2[8:10])
                                    if check2:
                                        self.textlog.insert(INSERT, 'Erase application area:'+self.App_addr_start + ' to ' + self.App_addr_end+ '\n', 'normal')
                                        UART_S.send_data(ser_port, self.range_erase_pack)
                                        response2 = UART_S.read_data(ser_port, 1)
                                        check = self.check_pack(response2)
                                        response2 = UART_S.read_data(ser_port, 9)
                                        check2 = self.check_reponse(response2[8:10])
                                        if check2:
                                            self.textlog.insert(INSERT, 'Send the firmware...\n', 'normal')
                                            # print(type(firmware_pack))
                                            # print(firmware_pack)
                                            for list_code in self.firmware_pack:
                                                UART_S.send_data(ser_port, list_code)
                                                response3 = UART_S.read_data(ser_port, 1)
                                                check = self.check_pack(response3)
                                                if check:
                                                    response3 = UART_S.read_data(ser_port, 9)
                                                    check3 = self.check_reponse(response3[8:10])
                                                    if check3:
                                                        pass
                                                    else:
                                                        break
                                                else:
                                                    break
                                            if check:
                                                self.textlog.insert(INSERT, 'Send firmware successfully!\n', 'normal')
                                                self.textlog.insert(INSERT, 'Boot reset the device to start application ...\n',
                                                                    'normal')
                                                self.textlog.insert(INSERT, '-----------Download finished!----------\n', 'pass')
                                                UART_S.send_data(ser_port, self.start_app_pack)
                                                response3 = UART_S.read_data(ser_port, 1)
                                                self.firmwaredfile = []
                                                self.entry.delete(0, 'end')
                                else:
                                    self.textlog.insert(INSERT, 'Error: No response！02\n', 'error')
                        else:
                            self.textlog.insert(INSERT, 'Error: No response！03\n', 'error')
                    else:
                        self.textlog.insert(INSERT, 'Error: No response！04\n', 'error')
            else:
                self.textlog.insert(INSERT, 'Error: Can not find MSP COM port!\n', 'error')
        else:
            self.textlog.insert(INSERT, 'Error: please choose all files above!\n', 'error')
        self.textlog.see(END)
        self.textlog.config(state=DISABLED)
    def clear_text(self):
        self.textlog.config(state=NORMAL)
        self.textlog.delete('2.0','end')
        self.textlog.insert(INSERT, '\n')
        self.textlog.config(state=DISABLED)
    def check_pack(self, pack_ack):
        flagg = 0
#        self.textlog.config(state=NORMAL)
        if pack_ack == '00':
            flagg = 1
            self.textlog.insert(INSERT, 'Send package successfully!\n', 'normal')
        elif pack_ack == '51':
            self.textlog.insert(INSERT, 'Error: Header incorrect!\n', 'error')
        elif pack_ack == '52':
            self.textlog.insert(INSERT, 'Error: Checksum incorrect!\n', 'error')
        elif pack_ack == '53':
            self.textlog.insert(INSERT, 'Error: Packet size zero!\n', 'error')
        elif pack_ack == '54':
            self.textlog.insert(INSERT, 'Error: Packet size too big!\n', 'error')
        elif pack_ack == '55':
            self.textlog.insert(INSERT, 'Error: Unknown error!\n', 'error')
        elif pack_ack == '56':
            self.textlog.insert(INSERT, 'Error: Unknown baud rate!\n', 'error')
        else:
            self.textlog.insert(INSERT, 'Error: Unknow ack error!' + pack_ack +'\n' , 'error')
 #       self.textlog.config(state=DISABLED)
        return flagg
    def check_reponse(self, pack_res):
        flagg = 0
 #       self.textlog.config(state=NORMAL)
        if pack_res == '00':
            flagg = 1
            self.textlog.insert(INSERT, 'Operation success!\n', 'normal')
        elif pack_res == '01':
            self.textlog.insert(INSERT, 'Error: flash program failed!\n', 'error')
        elif pack_res == '02':
            self.textlog.insert(INSERT, 'Error: Mass Erase failed!\n', 'error')
        elif pack_res == '04':
            self.textlog.insert(INSERT, 'Error: BSL locked!!\n', 'error')
        elif pack_res == '05':
            self.textlog.insert(INSERT, 'Error: BSL password error!\n', 'error')
        elif pack_res == '06':
            self.textlog.insert(INSERT, 'Error: Multiple BSL password error!\n', 'error')
        elif pack_res == '07':
            self.textlog.insert(INSERT, 'Error: Unknown Command!\n', 'error')
        elif pack_res == '08':
            self.textlog.insert(INSERT, 'Error: Invalid memory range!\n', 'error')
        elif pack_res == '0b':
            self.textlog.insert(INSERT, 'Error: Factory reset disabled!\n', 'error')
        elif pack_res == '0c':
            self.textlog.insert(INSERT, 'Error: Factory reset password error!\n', 'error')
        elif pack_res == '0d':
            self.textlog.insert(INSERT, 'Error: Read out disabled!\n', 'error')
        elif pack_res == '0e':
            self.textlog.insert(INSERT, 'Error: flash erase failed!\n', 'error')
        elif pack_res == '0f':
            self.textlog.insert(INSERT, 'Error: Factory reset failed!\n', 'error')
        elif pack_res == '10':
            self.textlog.insert(INSERT, 'Error: invalid address length!\n', 'error')
        elif pack_res == '11':
            self.textlog.insert(INSERT, 'Error: standalone verification invalid length!\n', 'error')
        else:
            self.textlog.insert(INSERT, 'Error: Unknow error!' + pack_res +'\n', 'error')
        return flagg
#        self.textlog.config(state=DISABLED)

    def create_linker(self):
        sub_win = Toplevel(root)
        sub_win.title('Generate linker files')
#        sub_win.attributes("-topmost", True)
        sub_win.geometry("700x350+300+200")
        sub_win.grab_set()
        frames0 = Frame(sub_win)
        frames0.pack(padx=50, pady=20, anchor=W)
        frames1 = Frame(sub_win)
        frames1.pack(padx=50, anchor=W)
        frames3 = Frame(sub_win)
        frames3.pack(pady=10)
        frames4 = Frame(sub_win)
        frames4.pack()

        self.labels0 = Label(frames0, text='Input device name:')
        self.labels0.pack(side='left')
        global input_name_s
        input_name_s = StringVar()
        self.entrys = Entry(frames0, width=50, textvariable=input_name_s)
        self.entrys.pack(side='left')
        self.labels2 = Label(frames0, text='(Example: MSPM0G3507)')
        self.labels2.pack(side='left')

        self.labels1 = Label(frames1, text='Choose a ouput folder:')
        self.labels1.pack(side='left')
        global out_name_s
        out_name_s = StringVar()
        self.entrys1 = Entry(frames1, width=50, textvariable=out_name_s)
        self.entrys1.pack(side='left')
        self.buttons1 = Button(frames1, text='Scan', command=self.choosefile_s)
        self.buttons1.pack(side='left')

        self.buttons2 = Button(frames3, text='Generate', command=self.generate_f)
        self.buttons2.pack()

        self.s2 = Scrollbar(frames4)
        self.s2.pack(side=RIGHT, fill=Y)
        self.textlogsub = Text(frames4, yscrollcommand=self.s2.set, width=70, height=10, bg='white')
        self.s2.config(command=self.textlogsub.yview)
        self.textlogsub.pack()
        self.textlogsub.tag_config('errors', foreground='red')
        self.textlogsub.tag_config('pass_s', foreground='green')
        self.textlogsub.config(state=DISABLED)

    def choosefile_s(self):
        f2 = askdirectory()
        out_name_s.set(f2)
        self.textlogsub.config(state=NORMAL)
        if f2:
            self.textlogsub.insert(INSERT, 'Choose a output folder:' + f2 + '\n')
        else:
            self.textlogsub.insert(INSERT, 'Error: Please choose a output folder.\n', 'errors')
        self.textlogsub.config(state=DISABLED)
    def generate_f(self):
        self.textlogsub.config(state=NORMAL)
        input_name = input_name_s.get()
        output_path = out_name_s.get()
        if input_name:
            input_name = input_name.lower()
            CMD_file = 'MSPM0_CMD_FILES/' + input_name + '.cmd'
            if os.path.exists(CMD_file):
                self.textlogsub.insert(INSERT, 'You have choose device:' + input_name + '\n')
                if output_path:
#                    self.textlogsub.insert(INSERT, output_path + '\n')
                    input_name_ = input_name[3:]
                    Linker_g.get_info(CMD_file, output_path)
                    self.textlogsub.insert(INSERT, '-----Generate linker files for CCS -----\n', 'pass_s')
                    self.textlogsub.insert(INSERT, '-----Generate device.h header file -----\n', 'pass_s')
                else:
                    self.textlogsub.insert(INSERT, 'Error: Please choose a output folder.\n', 'errors')
            else:
                self.textlogsub.insert(INSERT, 'Error: Can not find device ' + input_name, 'errors')
        else:
            self.textlogsub.insert(INSERT, 'Error: Please input device name first！', 'errors')
        self.textlogsub.config(state=DISABLED)

    def create_non_main_txt(self):
        sub_win2 = Toplevel(root)
        sub_win2.title('Generate non-main flash txt firmware')
        #        sub_win.attributes("-topmost", True)
        sub_win2.geometry("1230x280+300+200")
        sub_win2.grab_set()
        frames_0_0 = Frame(sub_win2)
        frames_0_0.pack()
        frames_0 = Frame(sub_win2)
        frames_0.pack(padx=10, pady=10, anchor=W)
        frames_1 = Frame(sub_win2)
        frames_1.pack()
        frames_2 = Frame(sub_win2)
        frames_2.pack()
        frames_3 = Frame(sub_win2)
        frames_3.pack()

        self.w2_labels_0_0 = Label(frames_0_0, text='Please choose a device family:')
        self.w2_labels_0_0.grid(column=0, row=0)
        self.w2_entrys_0_0 = Entry(frames_0_0, width=12)
        self.w2_entrys_0_0.grid(column=1, row=0)
        self.w2_entrys_0_0.delete(0, 'end')
        self.w2_entrys_0_0.insert(INSERT, self.device_var)
        self.w2_entrys_0_0['state'] = 'readonly'

        self.w2_buttons_0_0 = Button(frames_0_0, text='Change', command=self.Device_choose)
        self.w2_buttons_0_0.grid(column=2, row=0)



        self.w2_buttons1_0 = Button(frames_0, text='BCRCONFIGID', command=self.BCRCONFIGID_call)
        self.w2_buttons1_0.grid(column=0, row=1)

        self.w2_entrys1_0 = Entry(frames_0, width=12)
        self.w2_entrys1_0.grid(column=0, row=2)
        self.w2_entrys1_0.delete(0, 'end')
        self.w2_entrys1_0.insert(INSERT, self.BCRCONFIGID_var)
        self.w2_entrys1_0['state'] = 'readonly'

        self.w2_buttons1 = Button(frames_0, text='BOOTCFG0', command=self.BOOTCFG0_call)
        self.w2_buttons1.grid(column=1, row=1)

        self.w2_entrys1 = Entry(frames_0, width=12)
        self.w2_entrys1.grid(column=1, row=2)
        self.w2_entrys1.delete(0, 'end')
        self.w2_entrys1.insert(INSERT, self.BOOTCFG0_var)
        self.w2_entrys1['state'] = 'readonly'

        self.w2_buttons3 = Button(frames_0, text='BOOTCFG1', command=self.BOOTCFG1_call)
        self.w2_buttons3.grid(column=2, row=1)

        self.w2_entrys3 = Entry(frames_0, width=12)
        self.w2_entrys3.grid(column=2, row=2)
        self.w2_entrys3.delete(0, 'end')
        self.w2_entrys3.insert(INSERT, self.BOOTCFG1_var)
        self.w2_entrys3['state'] = 'readonly'

        self.w2_buttons2 = Button(frames_0, text='PWDDEBUGLOCK', command=self.input_SWDPW)
        self.w2_buttons2.grid(column=3, row=1)

        self.w2_buttons4 = Button(frames_0, text='BOOTCFG2', command=self.BOOTCFG2_call)
        self.w2_buttons4.grid(column=4, row=1)

        self.w2_entrys4 = Entry(frames_0, width=12)
        self.w2_entrys4.grid(column=4, row=2)
        self.w2_entrys4.delete(0, 'end')
        self.w2_entrys4.insert(INSERT, self.BOOTCFG2_var)
        self.w2_entrys4['state'] = 'readonly'

        self.w2_buttons9 = Button(frames_0, text='BOOTCFG3', command=self.BOOTCFG3_call)
        self.w2_buttons9.grid(column=5, row=1)

        self.w2_entrys9 = Entry(frames_0, width=12)
        self.w2_entrys9.grid(column=5, row=2)
        self.w2_entrys9.delete(0, 'end')
        self.w2_entrys9.insert(INSERT, self.BOOTCFG3_var)
        self.w2_entrys9['state'] = 'readonly'


        self.w2_buttons5 = Button(frames_0, text='PWDMASSERASE', command=self.input_MEPW)
        self.w2_buttons5.grid(column=6, row=1)

        self.w2_buttons6 = Button(frames_0, text='PWDFACTORYRESET', command=self.input_FRPW)
        self.w2_buttons6.grid(column=7, row=1)

        self.w2_buttons7 = Button(frames_0, text='FLASHSWP0', command=self.FLASHSWP0_call)
        self.w2_buttons7.grid(column=8, row=1)

        self.w2_entrys7 = Entry(frames_0, width=12)
        self.w2_entrys7.grid(column=8, row=2)
        self.w2_entrys7.delete(0, 'end')
        self.w2_entrys7.insert(INSERT, self.FLASHSWP0_var)
        self.w2_entrys7['state'] = 'readonly'

        self.w2_buttons8 = Button(frames_0, text='FLASHSWP1', command=self.FLASHSWP1_call)
        self.w2_buttons8.grid(column=9, row=1)

        self.w2_entrys8 = Entry(frames_0, width=12)
        self.w2_entrys8.grid(column=9, row=2)
        self.w2_entrys8.delete(0, 'end')
        self.w2_entrys8.insert(INSERT, self.FLASHSWP1_var)
        self.w2_entrys8['state'] = 'readonly'

        self.w2_buttons8_1 = Button(frames_0, text='BOOTCFG4', command=self.BOOTCFG4_call)
        self.w2_buttons8_1.grid(column=10, row=1)

        self.w2_entrys8_1 = Entry(frames_0, width=12)
        self.w2_entrys8_1.grid(column=10, row=2)
        self.w2_entrys8_1.delete(0, 'end')
        self.w2_entrys8_1.insert(INSERT, self.BOOTCFG4_var)
        self.w2_entrys8_1['state'] = 'readonly'


        self.w2_buttons10 = Button(frames_0, text='APPCRCSTART', command=self.APPCRCSTART_call)
        self.w2_buttons10.grid(column=11, row=1)

        self.w2_entrys10 = Entry(frames_0, width=12)
        self.w2_entrys10.grid(column=11, row=2)
        self.w2_entrys10.delete(0, 'end')
        self.w2_entrys10.insert(INSERT, self.APPCRCSTART_var)
        self.w2_entrys10['state'] = 'readonly'

        self.w2_buttons11 = Button(frames_0, text='APPCRCLEN', command=self.APPCRCLEN_call)
        self.w2_buttons11.grid(column=12, row=1)

        self.w2_entrys11 = Entry(frames_0, width=12)
        self.w2_entrys11.grid(column=12, row=2)
        self.w2_entrys11.delete(0, 'end')
        self.w2_entrys11.insert(INSERT, self.APPCRCLEN_var)
        self.w2_entrys11['state'] = 'readonly'

        self.w2_buttons12 = Button(frames_0, text='APPCRC', command=self.APPCRC_call)
        self.w2_buttons12.grid(column=13, row=1)

        self.w2_entrys12 = Entry(frames_0, width=12)
        self.w2_entrys12.grid(column=13, row=2)
        self.w2_entrys12.delete(0, 'end')
        self.w2_entrys12.insert(INSERT, self.APPCRC_var)
        self.w2_entrys12['state'] = 'readonly'

        self.w2_buttons13 = Button(frames_0, text='BSLCONFIGID', command=self.BSLID_call)
        self.w2_buttons13.grid(column=0, row=3)

        self.w2_entrys13 = Entry(frames_0, width=12)
        self.w2_entrys13.grid(column=0, row=4)
        self.w2_entrys13.delete(0, 'end')
        self.w2_entrys13.insert(INSERT, self.BSLID_var)
        self.w2_entrys13['state'] = 'readonly'

        self.w2_buttons13_1 = Button(frames_0, text='BSLPINCFG0', command=self.BSLPINCFG0_call)
        self.w2_buttons13_1.grid(column=1, row=3)

        self.w2_entrys13_1 = Entry(frames_0, width=12)
        self.w2_entrys13_1.grid(column=1, row=4)
        self.w2_entrys13_1.delete(0, 'end')
        self.w2_entrys13_1.insert(INSERT, self.BSLPINCFG0_var)
        self.w2_entrys13_1['state'] = 'readonly'

        self.w2_buttons13_2 = Button(frames_0, text='BSLPINCFG1', command=self.BSLPINCFG1_call)
        self.w2_buttons13_2.grid(column=2, row=3)

        self.w2_entrys13_2 = Entry(frames_0, width=12)
        self.w2_entrys13_2.grid(column=2, row=4)
        self.w2_entrys13_2.delete(0, 'end')
        self.w2_entrys13_2.insert(INSERT, self.BSLPINCFG1_var)
        self.w2_entrys13_2['state'] = 'readonly'

        self.w2_buttons14 = Button(frames_0, text='BSLCONFIG0', command=self.BSLCFG_call)
        self.w2_buttons14.grid(column=3, row=3)

        self.w2_entrys14 = Entry(frames_0, width=12)
        self.w2_entrys14.grid(column=3, row=4)
        self.w2_entrys14.delete(0, 'end')
        self.w2_entrys14.insert(INSERT, self.BSLCFG_var)
        self.w2_entrys14['state'] = 'readonly'

        self.w2_buttons15 = Button(frames_0, text='BSLPW', command=self.input_BSLPW)
        self.w2_buttons15.grid(column=4, row=3)

        self.w2_buttons16 = Button(frames_0, text='BSLPLUGINCFG', command=self.BSLPLUGINCFG_call)
        self.w2_buttons16.grid(column=5, row=3)

        self.w2_entrys16 = Entry(frames_0, width=12)
        self.w2_entrys16.grid(column=5, row=4)
        self.w2_entrys16.delete(0, 'end')
        self.w2_entrys16.insert(INSERT, self.BSLPLUGINCFG_var)
        self.w2_entrys16['state'] = 'readonly'

        self.w2_buttons17 = Button(frames_0, text='BSLPLUGINHOOK', command=self.input_BSLPLUGINHOOK)
        self.w2_buttons17.grid(column=6, row=3)

        self.w2_buttons18 = Button(frames_0, text='PATCHHOOKID', command=self.BSLALTCFG_call)
        self.w2_buttons18.grid(column=7, row=3)

        self.w2_entrys18 = Entry(frames_0, width=13)
        self.w2_entrys18.grid(column=7, row=4)
        self.w2_entrys18.delete(0, 'end')
        self.w2_entrys18.insert(INSERT, self.BSLALTCFG_var)
        self.w2_entrys18['state'] = 'readonly'

        self.w2_buttons19 = Button(frames_0, text='SBLADDRESS', command=self.BSLALTADDR_call)
        self.w2_buttons19.grid(column=8, row=3)

        self.w2_entrys19 = Entry(frames_0, width=12)
        self.w2_entrys19.grid(column=8, row=4)
        self.w2_entrys19.delete(0, 'end')
        self.w2_entrys19.insert(INSERT, self.BSLALTADDR_var)
        self.w2_entrys19['state'] = 'readonly'

        self.w2_buttons20 = Button(frames_0, text='BSLAPPVER', command=self.BSLAPPVER_call)
        self.w2_buttons20.grid(column=9, row=3)

        self.w2_entrys20 = Entry(frames_0, width=12)
        self.w2_entrys20.grid(column=9, row=4)
        self.w2_entrys20.delete(0, 'end')
        self.w2_entrys20.insert(INSERT, self.BSLAPPVER_var)
        self.w2_entrys20['state'] = 'readonly'

        self.w2_buttons21 = Button(frames_0, text='BSLCONFIG1', command=self.BSLSECCFG_call)
        self.w2_buttons21.grid(column=10, row=3)

        self.w2_entrys21 = Entry(frames_0, width=12)
        self.w2_entrys21.grid(column=10, row=4)
        self.w2_entrys21.delete(0, 'end')
        self.w2_entrys21.insert(INSERT, self.BSLSECCFG_var)
        self.w2_entrys21['state'] = 'readonly'

        self.w2_labels_22 = Label(frames_1, text='Set a configuration version(Like v1):')
        self.w2_labels_22.grid(column=7, row=0)

        self.w2_entrys22 = Entry(frames_1, width=12)
        self.w2_entrys22.grid(column=8, row=0)
        self.w2_entrys22.delete(0, 'end')
        self.w2_entrys22.insert(INSERT, self.version_var)

        self.w2_buttons22 = Button(frames_2, text='-----Generate-----', command=self.Generate_call)
        self.w2_buttons22.grid(column=4, row=0)

        self.non_s0 = Scrollbar(frames_3)
        self.non_s0.pack(side=RIGHT, fill=Y)
        self.non_textlogsub = Text(frames_3, yscrollcommand=self.non_s0.set, width=120, height=5, bg='white')
        self.non_s0.config(command=self.non_textlogsub.yview)
        self.non_textlogsub.pack()
        self.non_textlogsub.tag_config('errors', foreground='red')
        self.non_textlogsub.tag_config('pass_s', foreground='green')
        self.non_textlogsub.insert(INSERT, 'Two files will be generated: non-main flash firmware txt file and BSL password file.\n')
        self.non_textlogsub.insert(INSERT, 'The output files will be saved in the output folder.\n')
        self.non_textlogsub.config(state=DISABLED)

    def Device_choose(self):
        sub_win0_1_0 = Toplevel(root)
        sub_win0_1_0.title('Choose other device')
        #        sub_win.attributes("-topmost", True)
        sub_win0_1_0.geometry("250x130+400+500")
        sub_win0_1_0.grab_set()
        w0_1_frames_0_0 = Frame(sub_win0_1_0)
        w0_1_frames_0_0.pack(padx=10, pady=10, anchor=W)
        w0_1_frames_1_0 = Frame(sub_win0_1_0)
        w0_1_frames_1_0.pack(padx=100, pady=20, anchor=W)
        # self.w0_1_labels_2 = Label(w0_1_frames_0_0, text='         Current: ')
        # self.w0_1_labels_2.grid(column=0, row=1, sticky='w')
        self.w0_1_comboExample = ttk.Combobox(w0_1_frames_0_0,
                                    values=[
                                        "MSPM0Gxxxx",
                                        "MSPM0L1xxx",],state= 'readonly')
        self.w0_1_comboExample.set(self.device_var)
        self.w0_1_comboExample.grid(column=0, row=0, sticky='w')

        self.w0_1_buttons1_0 = Button(w0_1_frames_1_0, text='OK', command=self.Device_change_OK)
        self.w0_1_buttons1_0.pack()

    def Device_change_OK(self):
        self.non_textlogsub.config(state=NORMAL)
        self.device_var = self.w0_1_comboExample.get()

        if self.device_var == 'MSPM0L1xxx':
            self.D_iomux_max = 29
            self.D_BSLIVK_PAD_NUM_var = '19'
            self.D_BSLIVK_GPIOPIN_var = '18'

            # self.D_BSLPINCFG0_var = '0x02180217'
            self.D_UARTTX_MUX_SEL_var = '02'
            self.D_UARTTX_PAD_NUM_var = '24'
            self.D_UARTRX_MUX_SEL_var = '02'
            self.D_UARTRX_PAD_NUM_var = '23'

            # self.D_BSLPINCFG1_var = '0x03020301'
            self.D_I2CSCL_MUX_SEL_var = '03'
            self.D_I2CSCL_PAD_NUM_var = '02'
            self.D_I2CSDA_MUX_SEL_var = '03'
            self.D_I2CSDA_PAD_NUM_var = '01'

            self.BSLCFG_var = '0xFFFF1293'
            self.BSLPINCFG0_var = '0x02180217'
            self.BSLPINCFG1_var = '0x03020301'
            self.non_textlogsub.insert(INSERT, 'Device family changed to MSPM0L1xxx.\n')

        else :
            if self.device_var == 'MSPM0Gxxxx':
                self.D_iomux_max = 61
                self.D_BSLIVK_PAD_NUM_var = '40'
                self.D_BSLIVK_GPIOPIN_var = '18'

                # self.D_BSLPINCFG0_var = '0x02180217'
                self.D_UARTTX_MUX_SEL_var = '02'
                self.D_UARTTX_PAD_NUM_var = '21'
                self.D_UARTRX_MUX_SEL_var = '02'
                self.D_UARTRX_PAD_NUM_var = '22'

                # self.D_BSLPINCFG1_var = '0x03020301'
                self.D_I2CSCL_MUX_SEL_var = '03'
                self.D_I2CSCL_PAD_NUM_var = '02'
                self.D_I2CSDA_MUX_SEL_var = '03'
                self.D_I2CSDA_PAD_NUM_var = '01'
                self.BSLCFG_var = '0xFFFF12A8'
                self.BSLPINCFG0_var = '0x02150216'
                self.BSLPINCFG1_var = '0x03020301'
                self.non_textlogsub.insert(INSERT, 'Device family changed to MSPM0Gxxxx.\n')

        self.w2_entrys_0_0['state'] = 'normal'
        self.w2_entrys_0_0.delete(0, 'end')
        self.w2_entrys_0_0.insert(INSERT, self.device_var)
        self.w2_entrys_0_0['state'] = 'readonly'

        self.w2_entrys14['state'] = 'normal'
        self.w2_entrys14.delete(0, 'end')
        self.w2_entrys14.insert(INSERT, self.BSLCFG_var)
        self.w2_entrys14['state'] = 'readonly'

        self.w2_entrys13_1['state'] = 'normal'
        self.w2_entrys13_1.delete(0, 'end')
        self.w2_entrys13_1.insert(INSERT, self.BSLPINCFG0_var)
        self.w2_entrys13_1['state'] = 'readonly'

        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
    def BCRCONFIGID_call(self):
        sub_win0_1 = Toplevel(root)
        sub_win0_1.title('BCRCONFIGID')
        #        sub_win.attributes("-topmost", True)
        sub_win0_1.geometry("250x130+400+500")
        sub_win0_1.grab_set()
        w0_1_frames_0 = Frame(sub_win0_1)
        w0_1_frames_0.pack(padx=10, pady=10, anchor=W)
        w0_1_frames_1 = Frame(sub_win0_1)
        w0_1_frames_1.pack(padx=100, pady=20, anchor=W)
        self.w0_1_labels_2 = Label(w0_1_frames_0, text='         Configuration ID of BCR Structure: ')
        self.w0_1_labels_2.grid(column=0, row=1, sticky='w')

        self.w0_1_entrys_0 = Entry(w0_1_frames_0, width=15)
        self.w0_1_entrys_0.grid(column=0, row=2)
        self.w0_1_entrys_0.delete(0, 'end')
        self.w0_1_entrys_0.insert(INSERT, self.BCRCONFIGID_var)

        self.w0_1_buttons1 = Button(w0_1_frames_1, text='OK', command=self.BCRCONFIGID_OK)
        self.w0_1_buttons1.pack()
    def BCRCONFIGID_OK(self):
        self.BCRCONFIGID_var = self.w0_1_entrys_0.get()
        self.non_textlogsub.config(state=NORMAL)
        if len(self.BCRCONFIGID_var) != 10:
            self.BCRCONFIGID_var = '0x00000001'
            self.non_textlogsub.insert(INSERT, 'Input length of BCRCONFIGID is invalid.\n', 'errors')
        else:
            try:
                return_value = int(self.BCRCONFIGID_var, 16)
                self.non_textlogsub.insert(INSERT, 'BCRCONFIGID configuration finished.\n')
            except:
                self.BCRCONFIGID_var = '0x00000001'
                self.non_textlogsub.insert(INSERT, 'Input value of BCRCONFIGID is invalid.\n', 'errors')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
        self.w2_entrys1_0['state'] = 'normal'
        self.w2_entrys1_0.delete(0, 'end')
        self.w2_entrys1_0.insert(INSERT, self.BCRCONFIGID_var)
        self.w2_entrys1_0['state'] = 'readonly'
    def BOOTCFG0_call(self):
        sub_win4 = Toplevel(root)
        sub_win4.title('BOOTCFG0')
        #        sub_win.attributes("-topmost", True)
        sub_win4.geometry("900x250+400+500")
        sub_win4.grab_set()
        w4_frames_0 = Frame(sub_win4)
        w4_frames_0.pack(padx=10, pady=10, anchor=W)
        w4_frames_1 = Frame(sub_win4)
        w4_frames_1.pack(padx=400, pady=20, anchor=W)

        self.w4_labels_1 = Label(w4_frames_0, text='SWDP_MODE')
        self.w4_labels_1.grid(column=0, row=0, sticky='w')
        self.w4_labels_2 = Label(w4_frames_0, text='         The SW-DP is enabled and device access is set by the '
                                                    'additional policies in NONMAIN:(0xAABB:Enable; 0x5566(or other):Disable)')
        self.w4_labels_2.grid(column=0, row=1, sticky='w')
        self.w4_comboExample = ttk.Combobox(w4_frames_0,
                                    values=[
                                        "disabled",
                                        "enabled",],state= 'readonly')
        self.w4_comboExample.set(self.BOOTCFG0_var1)
        self.w4_comboExample.grid(column=1, row=1, sticky='w')

        self.w4_labels_3 = Label(w4_frames_0, text='DEBUGACCESS')
        self.w4_labels_3.grid(column=0, row=2, sticky='w')
        self.w4_labels_4 = Label(w4_frames_0, text='         The debug access policy for accessing the AHB-AP, ET-AP, and '
                                                    'PWR-AP debug access ports. \n'
                                                   '             disabled (0x5566: or other value not 0xCCDD or 0xAABB), \n'
                                                   '             enabled (0xAABB)\n'                                                                                    
                                                   '             enabled with password: (0xCCDD)', justify=LEFT)
        self.w4_labels_4.grid(column=0, row=3, sticky='w')
        self.w4_comboExample2 = ttk.Combobox(w4_frames_0,
                                    values=[
                                        "disabled",
                                        "enabled",
                                        "enabled_Password",],state= 'readonly')
        self.w4_comboExample2.set(self.BOOTCFG0_var2)
        self.w4_comboExample2.grid(column=1, row=4, sticky='w')

        self.W4_buttons1 = Button(w4_frames_1, text='OK', command=self.BOOTCFG0_OK)
        self.W4_buttons1.pack()

    def BOOTCFG0_OK(self):
        self.BOOTCFG0_var1 = self.w4_comboExample.get()
        self.BOOTCFG0_var2 = self.w4_comboExample2.get()
        if self.BOOTCFG0_var1 == 'enabled':
            self.BOOTCFG0_var = '0xAABB'+ self.BOOTCFG0_var[7:]
        else:
            self.BOOTCFG0_var= '0x5566'+ self.BOOTCFG0_var[7:]
        if self.BOOTCFG0_var2 == 'enabled':
            self.BOOTCFG0_var = self.BOOTCFG0_var[:6] + 'AABB'
        else:
            if self.BOOTCFG0_var2 == 'enabled_Password':
                self.BOOTCFG0_var = self.BOOTCFG0_var[:6] + 'CCDD'
            else:
                self.BOOTCFG0_var = self.BOOTCFG0_var[:6] + '5566'

        self.w2_entrys1['state'] = 'normal'
        self.w2_entrys1.delete(0, 'end')
        self.w2_entrys1.insert(INSERT, self.BOOTCFG0_var)
        self.w2_entrys1['state'] = 'readonly'
        # print(self.BOOTCFG0_var)
        self.non_textlogsub.config(state=NORMAL)
        self.non_textlogsub.insert(INSERT, 'BOOTCFG0 configuration finished.\n')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
    def input_SWDPW(self):
        sub_win3 = Toplevel(root)
        sub_win3.title('PWDDEBUGLOCK Configure')
        #        sub_win.attributes("-topmost", True)
        sub_win3.geometry("350x150+400+500")
        sub_win3.grab_set()
        w3_frames_0 = Frame(sub_win3)
        w3_frames_0.pack(padx=10, pady=10, anchor=W)
        w3_frames_1 = Frame(sub_win3)
        w3_frames_1.pack(padx=80, pady=10, anchor=W)
        self.w3_labels_0 = Label(w3_frames_0, text='0~31 bits:')
        self.w3_labels_0.grid(column=0, row=0)

        self.w3_entrys_0 = Entry(w3_frames_0, width=15)
        self.w3_entrys_0.grid(column=1, row=0)
        self.w3_entrys_0.delete(0, 'end')
        self.w3_entrys_0.insert(INSERT, self.SWDPW_S_0)

        self.w3_labels_1 = Label(w3_frames_0, text='32~63 bits:')
        self.w3_labels_1.grid(column=0, row=1)

        self.w3_entrys_1 = Entry(w3_frames_0, width=15)
        self.w3_entrys_1.grid(column=1, row=1)
        self.w3_entrys_1.delete(0, 'end')
        self.w3_entrys_1.insert(INSERT, self.SWDPW_S_1)

        self.w3_labels_2 = Label(w3_frames_0, text='64~95 bits:')
        self.w3_labels_2.grid(column=0, row=2)

        self.w3_entrys_2 = Entry(w3_frames_0, width=15)
        self.w3_entrys_2.grid(column=1, row=2)
        self.w3_entrys_2.delete(0, 'end')
        self.w3_entrys_2.insert(INSERT, self.SWDPW_S_2)

        self.w3_labels_3 = Label(w3_frames_0, text='96~127 bits:')
        self.w3_labels_3.grid(column=0, row=3)

        self.w3_entrys_3 = Entry(w3_frames_0, width=15)
        self.w3_entrys_3.grid(column=1, row=3)
        self.w3_entrys_3.delete(0, 'end')
        self.w3_entrys_3.insert(INSERT, self.SWDPW_S_3)

        self.w3_buttons_0 = Button(w3_frames_1, text='OK', command=self.SWDPW_OK)
        self.w3_buttons_0.pack()
    def SWDPW_OK(self):

        self.SWDPW_S_0 = self.w3_entrys_0.get()
        self.SWDPW_S_1 = self.w3_entrys_1.get()
        self.SWDPW_S_2 = self.w3_entrys_2.get()
        self.SWDPW_S_3 = self.w3_entrys_3.get()
        self.non_textlogsub.config(state=NORMAL)
        if len(self.SWDPW_S_0 + self.SWDPW_S_1 + self.SWDPW_S_2 + self.SWDPW_S_3) != 40:
            self.SWDPW_S_0 = '0xFFFFFFFF'
            self.SWDPW_S_1 = '0xFFFFFFFF'
            self.SWDPW_S_2 = '0xFFFFFFFF'
            self.SWDPW_S_3 = '0xFFFFFFFF'
            self.non_textlogsub.insert(INSERT, 'Input length of PWDDEBUGLOCK is invalid.\n', 'errors')
        else:
            try:
                return_value = int(self.SWDPW_S_0, 16)
                return_value = int(self.SWDPW_S_1, 16)
                return_value = int(self.SWDPW_S_2, 16)
                return_value = int(self.SWDPW_S_3, 16)
                self.non_textlogsub.insert(INSERT, 'PWDDEBUGLOCK configuration finished.\n')
            except:
                self.SWDPW_S_0 = '0xFFFFFFFF'
                self.SWDPW_S_1 = '0xFFFFFFFF'
                self.SWDPW_S_2 = '0xFFFFFFFF'
                self.SWDPW_S_3 = '0xFFFFFFFF'
                self.non_textlogsub.insert(INSERT, 'Input value of PWDDEBUGLOCK is invalid.\n', 'errors')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
    def BOOTCFG1_call(self):
        sub_win5 = Toplevel(root)
        sub_win5.title('BOOTCFG1')
        #        sub_win.attributes("-topmost", True)
        sub_win5.geometry("900x200+400+500")
        sub_win5.grab_set()
        w5_frames_0 = Frame(sub_win5)
        w5_frames_0.pack(padx=10, pady=10, anchor=W)
        w5_frames_1 = Frame(sub_win5)
        w5_frames_1.pack(padx=300, pady=20, anchor=W)
        self.w5_labels_0 = Label(w5_frames_0, text='BSL_PIN_INVOKE')
        self.w5_labels_0.grid(column=0, row=0, sticky='w')
        self.w5_labels_2 = Label(w5_frames_0, text='         Boot strap loader (BSL) pin invoke method enable/disable policy:(0xAABB:Enable; Other value(Default:0x5566):Disable)')
        self.w5_labels_2.grid(column=0, row=1, sticky='w')
        self.w5_comboExample = ttk.Combobox(w5_frames_0,
                                    values=[
                                        "disabled",
                                        "enabled",],state= 'readonly')
        self.w5_comboExample.set(self.BOOTCFG1_var1)
        self.w5_comboExample.grid(column=1, row=1, sticky='w')

        self.w5_labels_3 = Label(w5_frames_0, text='TI_FA_MODE')
        self.w5_labels_3.grid(column=0, row=2, sticky='w')
        self.w5_labels_4 = Label(w5_frames_0, text='         Sets the TI failure analysis enable/disable policy:(0xAABB:Enable; Other value(Default:0x5566):Disable)')
        self.w5_labels_4.grid(column=0, row=3, sticky='w')
        self.w5_comboExample2 = ttk.Combobox(w5_frames_0,
                                    values=[
                                        "disabled",
                                        "enabled",],state= 'readonly')
        self.w5_comboExample2.set(self.BOOTCFG1_var2)
        self.w5_comboExample2.grid(column=1, row=3, sticky='w')

        self.w5_buttons1 = Button(w5_frames_1, text='OK', command=self.BOOTCFG1_OK)
        self.w5_buttons1.pack()
    def BOOTCFG1_OK(self):
        self.BOOTCFG1_var1 = self.w5_comboExample.get()
        self.BOOTCFG1_var2 = self.w5_comboExample2.get()
        if self.BOOTCFG1_var1 == 'enabled':
            self.BOOTCFG1_var = '0xAABB'+ self.BOOTCFG1_var[7:]
        else:
            self.BOOTCFG1_var =  '0x5566'+ self.BOOTCFG1_var[7:]
        if self.BOOTCFG1_var2 == 'enabled':
            self.BOOTCFG1_var = self.BOOTCFG1_var[:6] + 'AABB'
        else:
            self.BOOTCFG1_var= self.BOOTCFG1_var[:6] + '5566'

        self.w2_entrys3['state'] = 'normal'
        self.w2_entrys3.delete(0, 'end')
        self.w2_entrys3.insert(INSERT, self.BOOTCFG1_var)
        self.w2_entrys3['state'] = 'readonly'
        self.non_textlogsub.config(state=NORMAL)
        self.non_textlogsub.insert(INSERT, 'BOOTCFG1 configuration finished.\n')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
    def BOOTCFG2_call(self):
        sub_win6 = Toplevel(root)
        sub_win6.title('BOOTCFG2')
        #        sub_win.attributes("-topmost", True)
        sub_win6.geometry("900x200+400+500")
        sub_win6.grab_set()
        w6_frames_0 = Frame(sub_win6)
        w6_frames_0.pack(padx=10, pady=10, anchor=W)
        w6_frames_1 = Frame(sub_win6)
        w6_frames_1.pack(padx=400, pady=20, anchor=W)
        self.w6_labels_0 = Label(w6_frames_0, text='BSLMODE')
        self.w6_labels_0.grid(column=0, row=0, sticky='w')
        self.w6_labels_2 = Label(w6_frames_0, text='         BSLMODE configures the boot strap loader enable/disable policy:(0xAABB:Enabled; Other value(default:0x5566):Disabled)')
        self.w6_labels_2.grid(column=0, row=1, sticky='w')
        self.w6_comboExample = ttk.Combobox(w6_frames_0,
                                    values=[
                                        "disabled",
                                        "enabled",],state= 'readonly')
        self.w6_comboExample.set(self.BOOTCFG2_var1)
        self.w6_comboExample.grid(column=1, row=1, sticky='w')

        self.w6_labels_3 = Label(w6_frames_0, text='FASTBOOTMODE')
        self.w6_labels_3.grid(column=0, row=2, sticky='w')
        self.w6_labels_4 = Label(w6_frames_0, text='         FASTBOOTMODE configures the fast boot mode enable/disable policy:(0xAABB:Enabled; Other value(default:0x5566):Disabled)')
        self.w6_labels_4.grid(column=0, row=3, sticky='w')
        self.w6_comboExample2 = ttk.Combobox(w6_frames_0,
                                    values=[
                                        "disabled",
                                        "enabled",],state= 'readonly')
        self.w6_comboExample2.set(self.BOOTCFG2_var2)
        self.w6_comboExample2.grid(column=1, row=3, sticky='w')

        self.w6_buttons1 = Button(w6_frames_1, text='OK', command=self.BOOTCFG2_OK)
        self.w6_buttons1.pack()
    def BOOTCFG2_OK(self):
        self.BOOTCFG2_var1 = self.w6_comboExample.get()
        self.BOOTCFG2_var2 = self.w6_comboExample2.get()
        if self.BOOTCFG2_var1 == 'enabled':
            self.BOOTCFG2_var = '0xAABB'+ self.BOOTCFG2_var[7:]
        else:
            self.BOOTCFG2_var = '0x5566' + self.BOOTCFG2_var[7:]

        if self.BOOTCFG2_var2 == 'enabled':
            self.BOOTCFG2_var = self.BOOTCFG2_var[:6] + 'AABB'
        else:
            self.BOOTCFG2_var = self.BOOTCFG2_var[:6] + '5566'

        self.w2_entrys4['state'] = 'normal'
        self.w2_entrys4.delete(0, 'end')
        self.w2_entrys4.insert(INSERT, self.BOOTCFG2_var)
        self.w2_entrys4['state'] = 'readonly'
        self.non_textlogsub.config(state=NORMAL)
        self.non_textlogsub.insert(INSERT, 'BOOTCFG2 configuration finished.\n')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
    def input_MEPW(self):
        sub_win7 = Toplevel(root)
        sub_win7.title('PWDMASSERASE Configure')
        #        sub_win.attributes("-topmost", True)
        sub_win7.geometry("300x150+400+500")
        sub_win7.grab_set()
        w7_frames_0 = Frame(sub_win7)
        w7_frames_0.pack(padx=10, pady=10, anchor=W)
        w7_frames_1 = Frame(sub_win7)
        w7_frames_1.pack(padx=80, pady=10, anchor=W)
        self.w7_labels_0 = Label(w7_frames_0, text='0~31 bits:')
        self.w7_labels_0.grid(column=0, row=0)

        self.w7_entrys_0 = Entry(w7_frames_0, width=15)
        self.w7_entrys_0.grid(column=1, row=0)
        self.w7_entrys_0.delete(0, 'end')
        self.w7_entrys_0.insert(INSERT, self.MEPW_S_0)

        self.w7_labels_1 = Label(w7_frames_0, text='32~63 bits:')
        self.w7_labels_1.grid(column=0, row=1)

        self.w7_entrys_1 = Entry(w7_frames_0, width=15)
        self.w7_entrys_1.grid(column=1, row=1)
        self.w7_entrys_1.delete(0, 'end')
        self.w7_entrys_1.insert(INSERT, self.MEPW_S_1)

        self.w7_labels_2 = Label(w7_frames_0, text='64~95 bits:')
        self.w7_labels_2.grid(column=0, row=2)

        self.w7_entrys_2 = Entry(w7_frames_0, width=15)
        self.w7_entrys_2.grid(column=1, row=2)
        self.w7_entrys_2.delete(0, 'end')
        self.w7_entrys_2.insert(INSERT, self.MEPW_S_2)

        self.w7_labels_3 = Label(w7_frames_0, text='96~127 bits:')
        self.w7_labels_3.grid(column=0, row=3)

        self.w7_entrys_3 = Entry(w7_frames_0, width=15)
        self.w7_entrys_3.grid(column=1, row=3)
        self.w7_entrys_3.delete(0, 'end')
        self.w7_entrys_3.insert(INSERT, self.MEPW_S_3)

        self.w7_buttons_0 = Button(w7_frames_1, text='OK', command=self.MEPW_OK)
        self.w7_buttons_0.pack()
    def MEPW_OK(self):
        self.MEPW_S_0 = self.w7_entrys_0.get()
        self.MEPW_S_1 = self.w7_entrys_1.get()
        self.MEPW_S_2 = self.w7_entrys_2.get()
        self.MEPW_S_3 = self.w7_entrys_3.get()
        self.non_textlogsub.config(state=NORMAL)
        if len(self.MEPW_S_0 + self.MEPW_S_1 + self.MEPW_S_2 + self.MEPW_S_3) != 40:
            self.MEPW_S_0 = '0xFFFFFFFF'
            self.MEPW_S_1 = '0xFFFFFFFF'
            self.MEPW_S_2 = '0xFFFFFFFF'
            self.MEPW_S_3 = '0xFFFFFFFF'
            self.non_textlogsub.insert(INSERT, 'Input length of PWDMASSERASE is invalid.\n', 'errors')
        else:
            try:
                return_value = int(self.MEPW_S_0, 16)
                return_value = int(self.MEPW_S_0, 16)
                return_value = int(self.MEPW_S_0, 16)
                return_value = int(self.MEPW_S_0, 16)
                self.non_textlogsub.insert(INSERT, 'PWDMASSERASE configuration finished.\n')
            except:
                self.MEPW_S_0 = '0xFFFFFFFF'
                self.MEPW_S_1 = '0xFFFFFFFF'
                self.MEPW_S_2 = '0xFFFFFFFF'
                self.MEPW_S_3 = '0xFFFFFFFF'
                self.non_textlogsub.insert(INSERT, 'Input value of PWDMASSERASE is invalid.\n', 'errors')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
    def input_FRPW(self):
        sub_win8 = Toplevel(root)
        sub_win8.title('PWDFACTORYRESET Configure')
        #        sub_win.attributes("-topmost", True)
        sub_win8.geometry("300x150+400+500")
        sub_win8.grab_set()
        w8_frames_0 = Frame(sub_win8)
        w8_frames_0.pack(padx=10, pady=10, anchor=W)
        w8_frames_1 = Frame(sub_win8)
        w8_frames_1.pack(padx=80, pady=10, anchor=W)
        self.w8_labels_0 = Label(w8_frames_0, text='0~31 bits:')
        self.w8_labels_0.grid(column=0, row=0)

        self.w8_entrys_0 = Entry(w8_frames_0, width=15)
        self.w8_entrys_0.grid(column=1, row=0)
        self.w8_entrys_0.delete(0, 'end')
        self.w8_entrys_0.insert(INSERT, self.FRPW_S_0)

        self.w8_labels_1 = Label(w8_frames_0, text='32~63 bits:')
        self.w8_labels_1.grid(column=0, row=1)

        self.w8_entrys_1 = Entry(w8_frames_0, width=15)
        self.w8_entrys_1.grid(column=1, row=1)
        self.w8_entrys_1.delete(0, 'end')
        self.w8_entrys_1.insert(INSERT, self.FRPW_S_1)

        self.w8_labels_2 = Label(w8_frames_0, text='64~95 bits:')
        self.w8_labels_2.grid(column=0, row=2)

        self.w8_entrys_2 = Entry(w8_frames_0, width=15)
        self.w8_entrys_2.grid(column=1, row=2)
        self.w8_entrys_2.delete(0, 'end')
        self.w8_entrys_2.insert(INSERT, self.FRPW_S_2)

        self.w8_labels_3 = Label(w8_frames_0, text='96~127 bits:')
        self.w8_labels_3.grid(column=0, row=3)

        self.w8_entrys_3 = Entry(w8_frames_0, width=15)
        self.w8_entrys_3.grid(column=1, row=3)
        self.w8_entrys_3.delete(0, 'end')
        self.w8_entrys_3.insert(INSERT, self.FRPW_S_3)

        self.w8_buttons_0 = Button(w8_frames_1, text='OK', command=self.FRPW_OK)
        self.w8_buttons_0.pack()
    def FRPW_OK(self):
        self.FRPW_S_0 = self.w8_entrys_0.get()
        self.FRPW_S_1 = self.w8_entrys_1.get()
        self.FRPW_S_2 = self.w8_entrys_2.get()
        self.FRPW_S_3 = self.w8_entrys_3.get()
        self.non_textlogsub.config(state=NORMAL)
        if len(self.FRPW_S_0 + self.FRPW_S_1 + self.FRPW_S_2 + self.FRPW_S_3) != 40:
            self.FRPW_S_0 = '0xFFFFFFFF'
            self.FRPW_S_1 = '0xFFFFFFFF'
            self.FRPW_S_2 = '0xFFFFFFFF'
            self.FRPW_S_3 = '0xFFFFFFFF'
            self.non_textlogsub.insert(INSERT, 'Input length of PWDFACTORYRESET is invalid.\n', 'errors')
        else:
            try:
                return_value = int(self.FRPW_S_0, 16)
                return_value = int(self.FRPW_S_0, 16)
                return_value = int(self.FRPW_S_0, 16)
                return_value = int(self.FRPW_S_0, 16)
                self.non_textlogsub.insert(INSERT, 'PWDFACTORYRESET configuration finished.\n')
            except:
                self.FRPW_S_0 = '0xFFFFFFFF'
                self.FRPW_S_1 = '0xFFFFFFFF'
                self.FRPW_S_2 = '0xFFFFFFFF'
                self.FRPW_S_3 = '0xFFFFFFFF'
                self.non_textlogsub.insert(INSERT, 'Input value of PWDFACTORYRESET is invalid.\n', 'errors')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
    def FLASHSWP0_call(self):
        sub_win9 = Toplevel(root)
        sub_win9.title('FLASHSWP0')
        #        sub_win.attributes("-topmost", True)
        sub_win9.geometry("700x200+400+500")
        sub_win9.grab_set()
        w9_frames_0 = Frame(sub_win9)
        w9_frames_0.pack(padx=10, pady=10, anchor=W)
        w9_frames_1 = Frame(sub_win9)
        w9_frames_1.pack(padx=300, pady=20, anchor=W)
        self.w9_labels_2 = Label(w9_frames_0, text='         Flash memory static write protection policy for the lower 32 sectors of the flash memory (1 bit per sector).\n'
                                                    'When sectors are protected, they may not be erased or programmed by application code or the BSL.')
        self.w9_labels_2.grid(column=0, row=1, sticky='w')

        self.w9_entrys_0 = Entry(w9_frames_0, width=15)
        self.w9_entrys_0.grid(column=0, row=2)
        self.w9_entrys_0.delete(0, 'end')
        self.w9_entrys_0.insert(INSERT, self.FLASHSWP0_var)

        self.w9_buttons1 = Button(w9_frames_1, text='OK', command=self.FLASHSWP0_OK)
        self.w9_buttons1.pack()
    def FLASHSWP0_OK(self):
        self.FLASHSWP0_var = self.w9_entrys_0.get()
        self.non_textlogsub.config(state=NORMAL)
        if len(self.FLASHSWP0_var) != 10:
            self.FLASHSWP0_var = '0xFFFFFFFF'
            self.non_textlogsub.insert(INSERT, 'Input length of FLASHSWP0 is invalid.\n', 'errors')
        else:
            try:
                return_value = int(self.FLASHSWP0_var, 16)
                self.non_textlogsub.insert(INSERT, 'FLASHSWP0 configuration finished.\n')
            except:
                self.FLASHSWP0_var = '0xFFFFFFFF'
                self.non_textlogsub.insert(INSERT, 'Input value of FLASHSWP0 is invalid.\n', 'errors')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)

        self.w2_entrys7['state'] = 'normal'
        self.w2_entrys7.delete(0, 'end')
        self.w2_entrys7.insert(INSERT, self.FLASHSWP0_var)
        self.w2_entrys7['state'] = 'readonly'

    def FLASHSWP1_call(self):
        sub_win10 = Toplevel(root)
        sub_win10.title('FLASHSWP1')
        #        sub_win.attributes("-topmost", True)
        sub_win10.geometry("700x200+400+500")
        sub_win10.grab_set()
        w10_frames_0 = Frame(sub_win10)
        w10_frames_0.pack(padx=10, pady=10, anchor=W)
        w10_frames_1 = Frame(sub_win10)
        w10_frames_1.pack(padx=300, pady=20, anchor=W)
        self.w10_labels_2 = Label(w10_frames_0, text='         Flash memory static write protection policy for the remaining sectors of flash memory(1 bit per 8 sectors).\n'
                                                    'When sectors are protected, they may not be erased or programmed by application code or the BSL.')
        self.w10_labels_2.grid(column=0, row=1, sticky='w')

        self.w10_entrys_0 = Entry(w10_frames_0, width=15)
        self.w10_entrys_0.grid(column=0, row=2)
        self.w10_entrys_0.delete(0, 'end')
        self.w10_entrys_0.insert(INSERT, self.FLASHSWP1_var)

        self.w10_buttons1 = Button(w10_frames_1, text='OK', command=self.FLASHSWP1_OK)
        self.w10_buttons1.pack()
    def FLASHSWP1_OK(self):
        self.FLASHSWP1_var = self.w10_entrys_0.get()
        self.non_textlogsub.config(state=NORMAL)
        if len(self.FLASHSWP1_var) != 10:
            self.FLASHSWP1_var = '0xFFFFFFFF'
            self.non_textlogsub.insert(INSERT, 'Input length of FLASHSWP1 is invalid.\n', 'errors')
        else:
            try:
                return_value = int(self.FLASHSWP1_var, 16)
                self.non_textlogsub.insert(INSERT, 'FLASHSWP1 configuration finished.\n')
            except:
                self.FLASHSWP1_var = '0xFFFFFFFF'
                self.non_textlogsub.insert(INSERT, 'Input value of FLASHSWP1 is invalid.\n', 'errors')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
        self.w2_entrys8['state'] = 'normal'
        self.w2_entrys8.delete(0, 'end')
        self.w2_entrys8.insert(INSERT, self.FLASHSWP1_var)
        self.w2_entrys7['state'] = 'readonly'

    def BOOTCFG3_call(self):
        sub_win11 = Toplevel(root)
        sub_win11.title('BOOTCFG3')
        #        sub_win.attributes("-topmost", True)
        sub_win11.geometry("430x200+400+500")
        sub_win11.grab_set()
        w11_frames_0 = Frame(sub_win11)
        w11_frames_0.pack(padx=10, pady=10, anchor=W)
        w11_frames_1 = Frame(sub_win11)
        w11_frames_1.pack(padx=200, pady=20, anchor=W)
        self.w11_labels_0 = Label(w11_frames_0, text='FACTORYRESETCMDACCESS')
        self.w11_labels_0.grid(column=0, row=0, sticky='w')
        self.w11_labels_2 = Label(w11_frames_0, text='   The factory reset command policy: ')
        self.w11_labels_2.grid(column=0, row=1, sticky='w')
        self.w11_comboExample = ttk.Combobox(w11_frames_0,
                                    values=[
                                        "enabled",
                                        "enabled_password",
                                        "disabled",],state= 'readonly')
        self.w11_comboExample.set(self.BOOTCFG3_var1)
        self.w11_comboExample.grid(column=1, row=1, sticky='w')

        self.w11_labels_3 = Label(w11_frames_0, text='MASSERASECMDACCESS')
        self.w11_labels_3.grid(column=0, row=2, sticky='w')
        self.w11_labels_4 = Label(w11_frames_0, text='         The mass erase command policy: ')
        self.w11_labels_4.grid(column=0, row=3, sticky='w')
        self.w11_comboExample2 = ttk.Combobox(w11_frames_0,
                                    values=[
                                        "enabled",
                                        "enabled_password",
                                        "disabled", ],state= 'readonly')
        self.w11_comboExample2.set(self.BOOTCFG3_var2)
        self.w11_comboExample2.grid(column=1, row=3, sticky='w')

        self.w11_buttons1 = Button(w11_frames_1, text='OK', command=self.BOOTCFG3_OK)
        self.w11_buttons1.pack()
    def BOOTCFG3_OK(self):
        self.BOOTCFG3_var1 = self.w11_comboExample.get()
        self.BOOTCFG3_var2 = self.w11_comboExample2.get()
        if self.BOOTCFG3_var1 == 'enabled':
            self.BOOTCFG3_var = '0xAABB' + self.BOOTCFG3_var[7:]
        else:
            if self.BOOTCFG3_var1 == 'enabled_password':
                self.BOOTCFG3_var = '0xCCDD' + self.BOOTCFG3_var[7:]
            else:
                self.BOOTCFG3_var = '0x5566' + self.BOOTCFG3_var[7:]
        if self.BOOTCFG3_var2 == 'enabled':
            self.BOOTCFG3_var = self.BOOTCFG3_var[:6] + 'AABB'
        else:
            if self.BOOTCFG3_var2 == 'enabled_password':
                self.BOOTCFG3_var= self.BOOTCFG3_var[:6] + 'CCDD'
            else:
                self.BOOTCFG3_var = self.BOOTCFG3_var[:6] + '5566'
        self.w2_entrys9['state'] = 'normal'
        self.w2_entrys9.delete(0, 'end')
        self.w2_entrys9.insert(INSERT, self.BOOTCFG3_var)
        self.w2_entrys9['state'] = 'readonly'
        self.non_textlogsub.config(state=NORMAL)
        self.non_textlogsub.insert(INSERT, 'BOOTCFG3 configuration finished.\n')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
    def BOOTCFG4_call(self):
        sub_win11_1 = Toplevel(root)
        sub_win11_1.title('BOOTCFG4')
        #        sub_win.attributes("-topmost", True)
        sub_win11_1.geometry("700x200+400+500")
        sub_win11_1.grab_set()
        w11_frames_0_1 = Frame(sub_win11_1)
        w11_frames_0_1.pack(padx=10, pady=10, anchor=W)
        w11_frames_1_1 = Frame(sub_win11_1)
        w11_frames_1_1.pack(padx=200, pady=20, anchor=W)
        self.w11_labels_0_1 = Label(w11_frames_0_1, text='APPCRCMODE')
        self.w11_labels_0_1.grid(column=0, row=0, sticky='w')
        self.w11_labels_2_1 = Label(w11_frames_0_1, text='         APPCRCMODE enables or disables the boot time CRC check of a segement of\n'
                                                     '         MAIN flash memory.(0xAABB:Enabled; Other value(default:0x5566):Disabled)')
        self.w11_labels_2_1.grid(column=0, row=1, sticky='w')
        self.w11_comboExample = ttk.Combobox(w11_frames_0_1,
                                    values=[
                                        "disabled",
                                        "enabled",],state= 'readonly')
        self.w11_comboExample.set(self.BOOTCFG4_var1)
        self.w11_comboExample.grid(column=1, row=1, sticky='w')

        self.w11_labels_3_1 = Label(w11_frames_0_1, text='NONMAINLOCK')
        self.w11_labels_3_1.grid(column=0, row=2, sticky='w')
        self.w11_labels_4_1 = Label(w11_frames_0_1, text='         NONMAINLOCK specifies whether the NONMAIN configuration memory\n'
                                                     '     may be modified by application code or the BSL.:(0:locked; 1:unlocked)')
        self.w11_labels_4_1.grid(column=0, row=3, sticky='w')
        self.w11_comboExample2 = ttk.Combobox(w11_frames_0_1,
                                    values=[
                                        "locked",
                                        "unlocked",],state= 'readonly')
        self.w11_comboExample2.set(self.BOOTCFG4_var2)
        self.w11_comboExample2.grid(column=1, row=3, sticky='w')

        self.w11_buttons1_1 = Button(w11_frames_1_1, text='OK', command=self.BOOTCFG4_OK)
        self.w11_buttons1_1.pack()
    def BOOTCFG4_OK(self):
        self.BOOTCFG4_var1 = self.w11_comboExample.get()
        self.BOOTCFG4_var2 = self.w11_comboExample2.get()
        if self.BOOTCFG4_var1 == 'enabled':
            self.BOOTCFG4_var = '0xAABB' + self.BOOTCFG4_var[7:]
        else:
            self.BOOTCFG4_var = '0x5566' + self.BOOTCFG4_var[7:]
        if self.BOOTCFG4_var2 == 'locked':
            self.BOOTCFG4_var = self.BOOTCFG4_var[:6] + 'FFFE'
        else:
            self.BOOTCFG4_var = self.BOOTCFG4_var[:6] + 'FFFF'
        self.w2_entrys8_1['state'] = 'normal'
        self.w2_entrys8_1.delete(0, 'end')
        self.w2_entrys8_1.insert(INSERT, self.BOOTCFG4_var)
        self.w2_entrys8_1['state'] = 'readonly'
        self.non_textlogsub.config(state=NORMAL)
        self.non_textlogsub.insert(INSERT, 'BOOTCFG4 configuration finished.\n')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
    def APPCRCSTART_call(self):
        sub_win12 = Toplevel(root)
        sub_win12.title('APPCRCSTART')
        #        sub_win.attributes("-topmost", True)
        sub_win12.geometry("500x100+400+500")
        sub_win12.grab_set()
        w12_frames_0 = Frame(sub_win12)
        w12_frames_0.pack(padx=10, pady=10, anchor=W)
        w12_frames_1 = Frame(sub_win12)
        w12_frames_1.pack(padx=200, pady=10, anchor=W)
        self.w12_labels_2 = Label(w12_frames_0, text='Start address of the application CRC check (must be an address in a MAIN flash region).')
        self.w12_labels_2.grid(column=0, row=1, sticky='w')

        self.w12_entrys_0 = Entry(w12_frames_0, width=15)
        self.w12_entrys_0.grid(column=0, row=2)
        self.w12_entrys_0.delete(0, 'end')
        self.w12_entrys_0.insert(INSERT, self.APPCRCSTART_var)

        self.w12_buttons1 = Button(w12_frames_1, text='OK', command=self.APPCRCSTART_OK)
        self.w12_buttons1.pack()
    def APPCRCSTART_OK(self):
        self.APPCRCSTART_var = self.w12_entrys_0.get()
        counter_buf = 2
        while len(self.APPCRCSTART_var) < 10:
            self.APPCRCSTART_var = self.APPCRCSTART_var[:counter_buf] + '0' + self.APPCRCSTART_var[counter_buf:]
            counter_buf += 1
        self.non_textlogsub.config(state=NORMAL)
        if len(self.APPCRCSTART_var) != 10:
            self.APPCRCSTAR_var = '0xFFFFFFFF'
            self.non_textlogsub.insert(INSERT, 'Input length of APPCRCSTAR is invalid.\n', 'errors')
        else:
            try:
                return_value = int(self.APPCRCSTART_var, 16)
                self.non_textlogsub.insert(INSERT, 'APPCRCSTAR configuration finished.\n')
            except:
                self.APPCRCSTART_var = '0xFFFFFFFF'
                self.non_textlogsub.insert(INSERT, 'Input value of APPCRCSTAR is invalid.\n', 'errors')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
        self.w2_entrys10['state'] = 'normal'
        self.w2_entrys10.delete(0, 'end')
        self.w2_entrys10.insert(INSERT, self.APPCRCSTART_var)
        self.w2_entrys10['state'] = 'readonly'
    def APPCRCLEN_call(self):
        sub_win13 = Toplevel(root)
        sub_win13.title('APPCRCLEN')
        #        sub_win.attributes("-topmost", True)
        sub_win13.geometry("500x100+400+500")
        sub_win13.grab_set()
        w13_frames_0 = Frame(sub_win13)
        w13_frames_0.pack(padx=10, pady=10, anchor=W)
        w13_frames_1 = Frame(sub_win13)
        w13_frames_1.pack(padx=200, pady=10, anchor=W)
        self.w13_labels_2 = Label(w13_frames_0, text='Length of the application CRC check.')
        self.w13_labels_2.grid(column=0, row=1, sticky='w')

        self.w13_entrys_0 = Entry(w13_frames_0, width=15)
        self.w13_entrys_0.grid(column=0, row=2)
        self.w13_entrys_0.delete(0, 'end')
        self.w13_entrys_0.insert(INSERT, self.APPCRCLEN_var)

        self.w13_buttons1 = Button(w13_frames_1, text='OK', command=self.APPCRCLEN_OK)
        self.w13_buttons1.pack()
    def APPCRCLEN_OK(self):
        self.APPCRCLEN_var = self.w13_entrys_0.get()
        counter_buf = 2
        while len(self.APPCRCLEN_var) < 10:
            self.APPCRCLEN_var = self.APPCRCLEN_var[:counter_buf] + '0' + self.APPCRCLEN_var[counter_buf:]
            counter_buf += 1
        self.non_textlogsub.config(state=NORMAL)
        if len(self.APPCRCLEN_var) != 10:
            self.APPCRCLEN_var = '0xFFFFFFFF'
            self.non_textlogsub.insert(INSERT, 'Input length of APPCRCLEN is invalid.\n', 'errors')
        else:
            try:
                return_value = int(self.APPCRCLEN_var, 16)
                self.non_textlogsub.insert(INSERT, 'APPCRCLEN configuration finished.\n')
            except:
                self.APPCRCLEN_var = '0xFFFFFFFF'
                self.non_textlogsub.insert(INSERT, 'Input value of APPCRCLEN is invalid.\n', 'errors')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
        self.w2_entrys11['state'] = 'normal'
        self.w2_entrys11.delete(0, 'end')
        self.w2_entrys11.insert(INSERT, self.APPCRCLEN_var)
        self.w2_entrys11['state'] = 'readonly'

    def APPCRC_call(self):
        sub_win14 = Toplevel(root)
        sub_win14.title('APPCRC')
        #        sub_win.attributes("-topmost", True)
        sub_win14.geometry("500x100+400+500")
        sub_win14.grab_set()
        w14_frames_0 = Frame(sub_win14)
        w14_frames_0.pack(padx=10, pady=10, anchor=W)
        w14_frames_1 = Frame(sub_win14)
        w14_frames_1.pack(padx=200, pady=10, anchor=W)
        self.w14_labels_2 = Label(w14_frames_0, text='Result of the application CRC check.')
        self.w14_labels_2.grid(column=0, row=1, sticky='w')

        self.w14_entrys_0 = Entry(w14_frames_0, width=15)
        self.w14_entrys_0.grid(column=0, row=2)
        self.w14_entrys_0.delete(0, 'end')
        self.w14_entrys_0.insert(INSERT, self.APPCRC_var)

        self.w14_buttons1 = Button(w14_frames_1, text='OK', command=self.APPCRC_OK)
        self.w14_buttons1.pack()
    def APPCRC_OK(self):
        self.APPCRC_var = self.w14_entrys_0.get()
        counter_buf = 2
        while len(self.APPCRC_var) < 10:
            self.APPCRC_var = self.APPCRC_var[:counter_buf] + '0' + self.APPCRC_var[counter_buf:]
            counter_buf += 1
        self.non_textlogsub.config(state=NORMAL)
        if len(self.APPCRC_var) != 10:
            self.APPCRC_var = '0xFFFFFFFF'
            self.non_textlogsub.insert(INSERT, 'Input length of APPCRC is invalid.\n', 'errors')
        else:
            try:
                return_value = int(self.APPCRC_var, 16)
                self.non_textlogsub.insert(INSERT, 'APPCRC configuration finished.\n')
            except:
                self.APPCRC_var = '0xFFFFFFFF'
                self.non_textlogsub.insert(INSERT, 'Input value of APPCRC is invalid.\n', 'errors')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
        self.w2_entrys12['state'] = 'normal'
        self.w2_entrys12.delete(0, 'end')
        self.w2_entrys12.insert(INSERT, self.APPCRC_var)
        self.w2_entrys12['state'] = 'readonly'

    def BSLID_call(self):
        sub_win15 = Toplevel(root)
        sub_win15.title('BSLCONFIGID')
        #        sub_win.attributes("-topmost", True)
        sub_win15.geometry("500x100+400+500")
        sub_win15.grab_set()
        w15_frames_0 = Frame(sub_win15)
        w15_frames_0.pack(padx=10, pady=10, anchor=W)
        w15_frames_1 = Frame(sub_win15)
        w15_frames_1.pack(padx=200, pady=10, anchor=W)
        self.w15_labels_2 = Label(w15_frames_0, text='BSL configuration ID.')
        self.w15_labels_2.grid(column=0, row=1, sticky='w')

        self.w15_entrys_0 = Entry(w15_frames_0, width=15)
        self.w15_entrys_0.grid(column=0, row=2)
        self.w15_entrys_0.delete(0, 'end')
        self.w15_entrys_0.insert(INSERT, self.BSLID_var)

        self.w15_buttons1 = Button(w15_frames_1, text='OK', command=self.BSLID_OK)
        self.w15_buttons1.pack()
    def BSLID_OK(self):
        self.BSLID_var = self.w15_entrys_0.get()

        self.non_textlogsub.config(state=NORMAL)
        if len(self.BSLID_var) != 10:
            self.BSLID_var = '0x00000001'
            self.non_textlogsub.insert(INSERT, 'Input length of BSLCONFIGID is invalid.\n', 'errors')
        else:
            try:
                return_value = int(self.BSLID_var, 16)
                self.non_textlogsub.insert(INSERT, 'BSLCONFIGID configuration finished.\n')
            except:
                self.BSLID_var = '0x00000001'
                self.non_textlogsub.insert(INSERT, 'Input value of BSLCONFIGID is invalid.\n', 'errors')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
        self.w2_entrys13['state'] = 'normal'
        self.w2_entrys13.delete(0, 'end')
        self.w2_entrys13.insert(INSERT, self.BSLID_var)
        self.w2_entrys13['state'] = 'readonly'

    def BSLPINCFG0_call(self):
        sub_win16_1 = Toplevel(root)
        sub_win16_1.title('BSLPINCFG0')
        #        sub_win.attributes("-topmost", True)
        sub_win16_1.geometry("500x260+400+500")
        sub_win16_1.grab_set()
        w16_frames_0_1 = Frame(sub_win16_1)
        w16_frames_0_1.pack(padx=10, pady=10, anchor=W)
        w16_frames_1_1 = Frame(sub_win16_1)
        w16_frames_1_1.pack(padx=200, pady=20, anchor=W)
        self.w16_labels_0_1 = Label(w16_frames_0_1, text='UARTTX_MUX_SEL')
        self.w16_labels_0_1.grid(column=0, row=0, sticky='w')
        self.w16_labels_2_1 = Label(w16_frames_0_1, text='         UART TX IOMUX PINCM mux selection')
        self.w16_labels_2_1.grid(column=0, row=1, sticky='w')
        self.w16_entrys_1_1 = Entry(w16_frames_0_1, width=15)
        self.w16_entrys_1_1.grid(column=1, row=1)
        self.w16_entrys_1_1.delete(0, 'end')
        self.w16_entrys_1_1.insert(INSERT, self.D_UARTTX_MUX_SEL_var)

        self.w16_labels_3_1 = Label(w16_frames_0_1, text=' UARTTX_PAD_NUM')
        self.w16_labels_3_1.grid(column=0, row=2, sticky='w')
        self.w16_labels_4_1 = Label(w16_frames_0_1, text='         UART TX IOMUX PINCM registe')
        self.w16_labels_4_1.grid(column=0, row=3, sticky='w')
        self.w16_entrys_1_2 = Entry(w16_frames_0_1, width=15)
        self.w16_entrys_1_2.grid(column=1, row=3)
        self.w16_entrys_1_2.delete(0, 'end')
        self.w16_entrys_1_2.insert(INSERT, self.D_UARTTX_PAD_NUM_var)

        self.w16_labels_5_1 = Label(w16_frames_0_1, text='UARTRX_MUX_SEL')
        self.w16_labels_5_1.grid(column=0, row=4, sticky='w')
        self.w16_labels_6_1 = Label(w16_frames_0_1, text='         UART RX IOMUX PINCM mux selection')
        self.w16_labels_6_1.grid(column=0, row=5, sticky='w')
        self.w16_entrys_2_1 = Entry(w16_frames_0_1, width=15)
        self.w16_entrys_2_1.grid(column=1, row=5)
        self.w16_entrys_2_1.delete(0, 'end')
        self.w16_entrys_2_1.insert(INSERT, self.D_UARTRX_MUX_SEL_var)

        self.w16_labels_5_2 = Label(w16_frames_0_1, text='UARTRX_PAD_NUM')
        self.w16_labels_5_2.grid(column=0, row=6, sticky='w')
        self.w16_labels_6_2 = Label(w16_frames_0_1, text='         UART RX IOMUX PINCM registe')
        self.w16_labels_6_2.grid(column=0, row=7, sticky='w')
        self.w16_entrys_2_2 = Entry(w16_frames_0_1, width=15)
        self.w16_entrys_2_2.grid(column=1, row=7)
        self.w16_entrys_2_2.delete(0, 'end')
        self.w16_entrys_2_2.insert(INSERT, self.D_UARTRX_PAD_NUM_var)

        self.w16_buttons1_1 = Button(w16_frames_1_1, text='OK', command=self.BSLPINCFG0_OK)
        self.w16_buttons1_1.pack()
    def BSLPINCFG0_OK(self):
        self.BSLPINCFG0_var1 = self.w16_entrys_1_1.get()
        self.BSLPINCFG0_var2 = self.w16_entrys_1_2.get()
        self.BSLPINCFG0_var3 = self.w16_entrys_2_1.get()
        self.BSLPINCFG0_var4 = self.w16_entrys_2_2.get()
        self.non_textlogsub.config(state=NORMAL)
        error_flag = 0
        try:
            ggtr = hex(int(self.BSLPINCFG0_var1)).upper()
            if len(ggtr) == 3:
                ggtr = '0x0' + ggtr[2]
            if len(ggtr) == 4:
                self.BSLPINCFG0_var = '0x' + ggtr[2:] + self.BSLPINCFG0_var[4:]
            else:
                self.non_textlogsub.insert(INSERT, 'UARTTX_MUX_SEL input value invalid in BSLPINCFG0.\n', 'errors')
                self.BSLPINCFG0_var1 = self.D_UARTTX_MUX_SEL_var
                error_flag = 1
        except :
            self.non_textlogsub.insert(INSERT, 'UARTTX_MUX_SEL input value invalid in BSLPINCFG0.\n', 'errors')
            self.BSLPINCFG0_var1 = self.D_UARTTX_MUX_SEL_var
            error_flag = 1
        try:
            ggtr = hex(int(self.BSLPINCFG0_var2)).upper()
            if len(ggtr) == 3:
                ggtr = '0x0' + ggtr[2]
            if len(ggtr) == 4:
                self.BSLPINCFG0_var = self.BSLPINCFG0_var[:4] + ggtr[2:] + self.BSLPINCFG0_var[6:]
            else:
                self.non_textlogsub.insert(INSERT, 'UARTTX_PAD_NUM input value invalid in BSLPINCFG0.\n', 'errors')
                self.BSLPINCFG0_var2 = self.D_UARTTX_PAD_NUM_var
                error_flag = 1
        except :
            self.non_textlogsub.insert(INSERT, 'UARTTX_PAD_NUM input value invalid in BSLPINCFG0.\n', 'errors')
            self.BSLPINCFG0_var2 = self.D_UARTTX_PAD_NUM_var
            error_flag = 1
        try:
            ggtr = hex(int(self.BSLPINCFG0_var3)).upper()
            if len(ggtr) == 3:
                ggtr = '0x0' + ggtr[2]
            if len(ggtr) == 4:
                self.BSLPINCFG0_var = self.BSLPINCFG0_var[:6] + ggtr[2:] + self.BSLPINCFG0_var[8:]
            else:
                self.non_textlogsub.insert(INSERT, 'UARTRX_MUX_SEL input value invalid in BSLPINCFG0.\n', 'errors')
                self.BSLPINCFG0_var3 = self.D_UARTRX_MUX_SEL_var
                error_flag = 1
        except :
            self.non_textlogsub.insert(INSERT, 'UARTRX_MUX_SEL input value invalid in BSLPINCFG0.\n', 'errors')
            self.BSLPINCFG0_var3 = self.D_UARTRX_MUX_SEL_var
            error_flag = 1
        try:
            ggtr = hex(int(self.BSLPINCFG0_var4)).upper()
            if len(ggtr) == 3:
                ggtr = '0x0' + ggtr[2]
            if len(ggtr) == 4:
                self.BSLPINCFG0_var = self.BSLPINCFG0_var[:8] + ggtr[2:] + self.BSLPINCFG0_var[10:]
            else:
                self.non_textlogsub.insert(INSERT, 'UARTRX_PAD_NUM input value invalid in BSLPINCFG0.\n', 'errors')
                self.BSLPINCFG0_var4 = self.D_UARTRX_PAD_NUMvar
                error_flag = 1
        except :
            self.non_textlogsub.insert(INSERT, 'UARTRX_PAD_NUM input value invalid in BSLPINCFG0.\n', 'errors')
            self.BSLPINCFG0_var4 = self.D_UARTRX_PAD_NUM_var
            error_flag = 1

        if error_flag == 0:
            self.w2_entrys13_1['state'] = 'normal'
            self.w2_entrys13_1.delete(0, 'end')
            self.w2_entrys13_1.insert(INSERT, self.BSLPINCFG0_var)
            self.w2_entrys13_1['state'] = 'readonly'
            self.non_textlogsub.insert(INSERT, 'BSLPINCFG0 configuration finished.\n')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)

    def BSLPINCFG1_call(self):
        sub_win16_2 = Toplevel(root)
        sub_win16_2.title('BSLPINCFG1')
        #        sub_win.attributes("-topmost", True)
        sub_win16_2.geometry("500x260+400+500")
        sub_win16_2.grab_set()
        w16_frames_0_2 = Frame(sub_win16_2)
        w16_frames_0_2.pack(padx=10, pady=10, anchor=W)
        w16_frames_1_2 = Frame(sub_win16_2)
        w16_frames_1_2.pack(padx=200, pady=20, anchor=W)
        self.w16_labels_0_2 = Label(w16_frames_0_2, text='I2CSCL_MUX_SEL')
        self.w16_labels_0_2.grid(column=0, row=0, sticky='w')
        self.w16_labels_2_2 = Label(w16_frames_0_2, text='         I2C SCL IOMUX PINCM mux selection')
        self.w16_labels_2_2.grid(column=0, row=1, sticky='w')
        self.w16_entrys_1_20 = Entry(w16_frames_0_2, width=15)
        self.w16_entrys_1_20.grid(column=1, row=1)
        self.w16_entrys_1_20.delete(0, 'end')
        self.w16_entrys_1_20.insert(INSERT, self.BSLPINCFG1_var1)

        self.w16_labels_3_2 = Label(w16_frames_0_2, text=' I2CSCL_PAD_NUM')
        self.w16_labels_3_2.grid(column=0, row=2, sticky='w')
        self.w16_labels_4_2 = Label(w16_frames_0_2, text='         2C SCL IOMUX PINCM register')
        self.w16_labels_4_2.grid(column=0, row=3, sticky='w')
        self.w16_entrys_1_3 = Entry(w16_frames_0_2, width=15)
        self.w16_entrys_1_3.grid(column=1, row=3)
        self.w16_entrys_1_3.delete(0, 'end')
        self.w16_entrys_1_3.insert(INSERT, self.BSLPINCFG1_var2)

        self.w16_labels_5_2 = Label(w16_frames_0_2, text='I2CSDA_MUX_SEL')
        self.w16_labels_5_2.grid(column=0, row=4, sticky='w')
        self.w16_labels_6_2 = Label(w16_frames_0_2, text='         I2C SDA IOMUX PINCM mux selection')
        self.w16_labels_6_2.grid(column=0, row=5, sticky='w')
        self.w16_entrys_2_3 = Entry(w16_frames_0_2, width=15)
        self.w16_entrys_2_3.grid(column=1, row=5)
        self.w16_entrys_2_3.delete(0, 'end')
        self.w16_entrys_2_3.insert(INSERT, self.BSLPINCFG1_var3)

        self.w16_labels_5_3 = Label(w16_frames_0_2, text='I2CSDA_PAD_NUM')
        self.w16_labels_5_3.grid(column=0, row=6, sticky='w')
        self.w16_labels_6_3 = Label(w16_frames_0_2, text='         I2C SDA IOMUX PINCM register')
        self.w16_labels_6_3.grid(column=0, row=7, sticky='w')
        self.w16_entrys_2_4 = Entry(w16_frames_0_2, width=15)
        self.w16_entrys_2_4.grid(column=1, row=7)
        self.w16_entrys_2_4.delete(0, 'end')
        self.w16_entrys_2_4.insert(INSERT, self.BSLPINCFG1_var4)

        self.w16_buttons1_2 = Button(w16_frames_1_2, text='OK', command=self.BSLPINCFG1_OK)
        self.w16_buttons1_2.pack()
    def BSLPINCFG1_OK(self):
        self.BSLPINCFG1_var1 = self.w16_entrys_1_20.get()
        self.BSLPINCFG1_var2 = self.w16_entrys_1_3.get()
        self.BSLPINCFG1_var3 = self.w16_entrys_2_3.get()
        self.BSLPINCFG1_var4 = self.w16_entrys_2_4.get()
        self.non_textlogsub.config(state=NORMAL)
        error_flag = 0
        try:
            ggtr = hex(int(self.BSLPINCFG1_var1)).upper()
            if len(ggtr) == 3:
                ggtr = '0x0' + ggtr[2]
            if len(ggtr) == 4:
                self.BSLPINCFG1_var = '0x' + ggtr[2:] + self.BSLPINCFG1_var[4:]
            else:
                self.non_textlogsub.insert(INSERT, 'I2CSCL_MUX_SEL input value invalid in BSLPINCFG1.\n', 'errors')
                self.BSLPINCFG1_var1 = '03'
                error_flag = 1
        except :
            self.non_textlogsub.insert(INSERT, 'I2CSCL_MUX_SEL input value invalid in BSLPINCFG1.\n', 'errors')
            self.BSLPINCFG1_var1 = '03'
            error_flag = 1
        try:
            ggtr = hex(int(self.BSLPINCFG1_var2)).upper()
            if len(ggtr) == 3:
                ggtr = '0x0' + ggtr[2]
            if len(ggtr) == 4:
                self.BSLPINCFG1_var = self.BSLPINCFG1_var[:4] + ggtr[2:] + self.BSLPINCFG1_var[6:]
            else:
                self.non_textlogsub.insert(INSERT, 'I2CSCL_PAD_NUM input value invalid in BSLPINCFG1.\n', 'errors')
                self.BSLPINCFG1_var2 = '02'
                error_flag = 1
        except :
            self.non_textlogsub.insert(INSERT, 'I2CSCL_PAD_NUM input value invalid in BSLPINCFG1.\n', 'errors')
            self.BSLPINCFG1_var2 = '02'
            error_flag = 1
        try:
            ggtr = hex(int(self.BSLPINCFG1_var3)).upper()
            if len(ggtr) == 3:
                ggtr = '0x0' + ggtr[2]
            if len(ggtr) == 4:
                self.BSLPINCFG1_var = self.BSLPINCFG1_var[:6] + ggtr[2:] + self.BSLPINCFG1_var[8:]
            else:
                self.non_textlogsub.insert(INSERT, 'I2CSDA_MUX_SEL input value invalid in BSLPINCFG1.\n', 'errors')
                self.BSLPINCFG1_var3 = '03'
                error_flag = 1
        except :
            self.non_textlogsub.insert(INSERT, 'I2CSDA_MUX_SEL input value invalid in BSLPINCFG1.\n', 'errors')
            self.BSLPINCFG1_var3 = '03'
            error_flag = 1
        try:
            ggtr = hex(int(self.BSLPINCFG1_var4)).upper()
            if len(ggtr) == 3:
                ggtr = '0x0' + ggtr[2]
            if len(ggtr) == 4:
                self.BSLPINCFG1_var = self.BSLPINCFG1_var[:8] + ggtr[2:] + self.BSLPINCFG1_var[10:]
            else:
                self.non_textlogsub.insert(INSERT, 'I2CSDA_PAD_NUM input value invalid in BSLPINCFG1.\n', 'errors')
                self.BSLPINCFG1_var4 = '01'
                error_flag = 1
        except :
            self.non_textlogsub.insert(INSERT, 'I2CSDA_PAD_NUM input value invalid in BSLPINCFG1.\n', 'errors')
            self.BSLPINCFG1_var4 = '01'
            error_flag = 1

        if error_flag == 0:
            self.w2_entrys13_2['state'] = 'normal'
            self.w2_entrys13_2.delete(0, 'end')
            self.w2_entrys13_2.insert(INSERT, self.BSLPINCFG1_var)
            self.w2_entrys13_2['state'] = 'readonly'
            self.non_textlogsub.insert(INSERT, 'BSLPINCFG1 configuration finished.\n')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)


    def BSLCFG_call(self):
        sub_win16 = Toplevel(root)
        sub_win16.title('BSLCONFIG0')
        #        sub_win.attributes("-topmost", True)
        sub_win16.geometry("800x300+400+500")
        sub_win16.grab_set()
        w16_frames_0 = Frame(sub_win16)
        w16_frames_0.pack(padx=10, pady=10, anchor=W)
        w16_frames_1 = Frame(sub_win16)
        w16_frames_1.pack(padx=300, pady=20, anchor=W)
        self.w16_labels_0 = Label(w16_frames_0, text='READOUTEN')
        self.w16_labels_0.grid(column=0, row=0, sticky='w')
        self.w16_labels_2 = Label(w16_frames_0, text='         Sets the memory read-out policy for the BSL interface:(0xAABB:Enabled; Other value(default:0x5566):Disabled)')
        self.w16_labels_2.grid(column=0, row=1, sticky='w')
        self.w16_comboExample = ttk.Combobox(w16_frames_0,
                                    values=[
                                        "disabled",
                                        "enabled",],state= 'readonly')
        self.w16_comboExample.set(self.BSLCFG_var1)
        self.w16_comboExample.grid(column=1, row=1, sticky='w')

        self.w16_labels_3 = Label(w16_frames_0, text='BSLIVK_GPIOPORT')
        self.w16_labels_3.grid(column=0, row=2, sticky='w')
        self.w16_labels_4 = Label(w16_frames_0, text='         The BSL_invoke GPIO port index corresponding to the pad used for BSL_invoke.')
        self.w16_labels_4.grid(column=0, row=3, sticky='w')
        self.w16_comboExample1 = ttk.Combobox(w16_frames_0,
                                    values=[
                                        "PA",
                                        "PB",],state= 'readonly')
        self.w16_comboExample1.set(self.BSLCFG_var2)
        self.w16_comboExample1.grid(column=1, row=3, sticky='w')

        self.w16_labels_5 = Label(w16_frames_0, text='BSLIVK_GPIOPIN')
        self.w16_labels_5.grid(column=0, row=4, sticky='w')
        self.w16_labels_6 = Label(w16_frames_0, text='         The BSL_invoke GPIO pin index corresponding to the pad used for BSL_invoke.')
        self.w16_labels_6.grid(column=0, row=5, sticky='w')
        self.w16_entrys_0 = Entry(w16_frames_0, width=15)
        self.w16_entrys_0.grid(column=1, row=5)
        self.w16_entrys_0.delete(0, 'end')
        self.w16_entrys_0.insert(INSERT, self.BSLCFG_var3)

        self.w16_labels_7 = Label(w16_frames_0, text='BSLIVK_LVL')
        self.w16_labels_7.grid(column=0, row=7, sticky='w')
        self.w16_labels_8 = Label(w16_frames_0, text='         The BSL_invoke input logic level which shall invoke the BSL.')
        self.w16_labels_8.grid(column=0, row=8, sticky='w')
        self.w16_comboExample2 = ttk.Combobox(w16_frames_0,
                                    values=[
                                        "high",
                                        "low",],state= 'readonly')
        self.w16_comboExample2.set(self.BSLCFG_var4)
        self.w16_comboExample2.grid(column=1, row=8, sticky='w')

        self.w16_labels_9 = Label(w16_frames_0, text='BSLIVK_PAD_NUM')
        self.w16_labels_9.grid(column=0, row=10, sticky='w')
        self.w16_labels_10 = Label(w16_frames_0, text='         The IOMUX PINCM register corresponding to the pad to be used for BSL_invoke. ')
        self.w16_labels_10.grid(column=0, row=11, sticky='w')
        self.w16_entrys_1 = Entry(w16_frames_0, width=15)
        self.w16_entrys_1.grid(column=1, row=11)
        self.w16_entrys_1.delete(0, 'end')
        self.w16_entrys_1.insert(INSERT, self.BSLCFG_var5)

        self.w16_buttons1 = Button(w16_frames_1, text='OK', command=self.BSLCFG_OK)
        self.w16_buttons1.pack()
    def BSLCFG_OK(self):
        self.BSLCFG_var1 = self.w16_comboExample.get()
        self.BSLCFG_var2 = self.w16_comboExample1.get()
        self.BSLCFG_var3 = self.w16_entrys_0.get()
        self.BSLCFG_var4 = self.w16_comboExample2.get()
        self.BSLCFG_var5 = self.w16_entrys_1.get()
        self.non_textlogsub.config(state=NORMAL)
        error_flag = 0
        if self.BSLCFG_var1 == 'enabled':
            self.BSLCFG_var = '0xAABB'+ self.BOOTCFG1_var[7:]
        else:
            self.BSLCFG_var =  '0xFFFF'+ self.BOOTCFG1_var[7:]
        try:
            if 32 > int(self.BSLCFG_var3):
                if self.BSLCFG_var2 == 'PA':
                    gg = hex(int(self.BSLCFG_var3))
                else:
                    gg = hex(int(self.BSLCFG_var3) + 32)
                ggtr = str(hex(int(gg, 16)))
                ggtr = ggtr.upper()
                if len(ggtr) == 3:
                    self.BSLCFG_var = self.BSLCFG_var[:6] + '0' + ggtr[2:]
                else:
                    self.BSLCFG_var = self.BSLCFG_var[:6] + ggtr[2:]
            else:
                self.non_textlogsub.insert(INSERT, 'BSLIVK_GPIOPIN input value invalid in BSLCONFIG0.\n', 'errors')
                self.BSLCFG_var3 = self.D_BSLIVK_GPIOPIN_var
                error_flag = 1
        except:
            self.non_textlogsub.insert(INSERT, 'BSLIVK_GPIOPIN input value invalid in BSLCONFIG0.\n', 'errors')
            self.BSLCFG_var3 = self.D_BSLIVK_GPIOPIN_var
            error_flag = 1
        try:
            if self.D_iomux_max > int(self.BSLCFG_var5):
                if self.BSLCFG_var4 == 'low':
                    gg2 = hex(int(self.BSLCFG_var5) + 0)
                else:
                    gg2 = hex(int(self.BSLCFG_var5) + 128)
                ggtr2 = str(hex(int(gg2, 16)))
                ggtr2 = ggtr2.upper()
                if len(ggtr2) == 3:
                    self.BSLCFG_var = self.BSLCFG_var[:8] +'0' + ggtr2[2:]
                else:
                    self.BSLCFG_var = self.BSLCFG_var[:8] + ggtr2[2:]
            else:
                self.non_textlogsub.insert(INSERT, 'BSLIVK_PAD_NUM input value invalid in BSLCONFIG0.\n', 'errors')
                self.BSLCFG_var5 = self.D_BSLIVK_PAD_NUM_var
                error_flag = 1
        except:
            self.non_textlogsub.insert(INSERT, 'BSLIVK_PAD_NUM input value invalid in BSLCONFIG0.\n', 'errors')
            self.BSLCFG_var5 = self.D_BSLIVK_PAD_NUM_var
            error_flag = 1
        if error_flag == 0:
            self.w2_entrys14['state'] = 'normal'
            self.w2_entrys14.delete(0, 'end')
            self.w2_entrys14.insert(INSERT, self.BSLCFG_var)
            self.w2_entrys14['state'] = 'readonly'

            self.non_textlogsub.insert(INSERT, 'BSLCONFIG0 configuration finished.\n')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
    def input_BSLPW(self):
        sub_win17 = Toplevel(root)
        sub_win17.title('SWDPW Configure')
        #        sub_win.attributes("-topmost", True)
        sub_win17.geometry("300x250+400+500")
        sub_win17.grab_set()
        w17_frames_0 = Frame(sub_win17)
        w17_frames_0.pack(padx=10, pady=10, anchor=W)
        w17_frames_1 = Frame(sub_win17)
        w17_frames_1.pack(padx=80, pady=10, anchor=W)
        self.w17_labels_0 = Label(w17_frames_0, text='0~31 bits:')
        self.w17_labels_0.grid(column=0, row=0)

        self.w17_entrys_0 = Entry(w17_frames_0, width=15)
        self.w17_entrys_0.grid(column=1, row=0)
        self.w17_entrys_0.delete(0, 'end')
        self.w17_entrys_0.insert(INSERT, self.BSLPW_S_0)

        self.w17_labels_1 = Label(w17_frames_0, text='32~63 bits:')
        self.w17_labels_1.grid(column=0, row=1)

        self.w17_entrys_1 = Entry(w17_frames_0, width=15)
        self.w17_entrys_1.grid(column=1, row=1)
        self.w17_entrys_1.delete(0, 'end')
        self.w17_entrys_1.insert(INSERT, self.BSLPW_S_1)

        self.w17_labels_2 = Label(w17_frames_0, text='64~95 bits:')
        self.w17_labels_2.grid(column=0, row=2)

        self.w17_entrys_2 = Entry(w17_frames_0, width=15)
        self.w17_entrys_2.grid(column=1, row=2)
        self.w17_entrys_2.delete(0, 'end')
        self.w17_entrys_2.insert(INSERT, self.BSLPW_S_2)

        self.w17_labels_3 = Label(w17_frames_0, text='96~127 bits:')
        self.w17_labels_3.grid(column=0, row=3)

        self.w17_entrys_3 = Entry(w17_frames_0, width=15)
        self.w17_entrys_3.grid(column=1, row=3)
        self.w17_entrys_3.delete(0, 'end')
        self.w17_entrys_3.insert(INSERT, self.BSLPW_S_3)

        self.w17_labels_4 = Label(w17_frames_0, text='128~159 bits:')
        self.w17_labels_4.grid(column=0, row=4)

        self.w17_entrys_4 = Entry(w17_frames_0, width=15)
        self.w17_entrys_4.grid(column=1, row=4)
        self.w17_entrys_4.delete(0, 'end')
        self.w17_entrys_4.insert(INSERT, self.BSLPW_S_4)

        self.w17_labels_5 = Label(w17_frames_0, text='160~191 bits:')
        self.w17_labels_5.grid(column=0, row=5)

        self.w17_entrys_5 = Entry(w17_frames_0, width=15)
        self.w17_entrys_5.grid(column=1, row=5)
        self.w17_entrys_5.delete(0, 'end')
        self.w17_entrys_5.insert(INSERT, self.BSLPW_S_5)

        self.w17_labels_6 = Label(w17_frames_0, text='192~223 bits:')
        self.w17_labels_6.grid(column=0, row=6)

        self.w17_entrys_6 = Entry(w17_frames_0, width=15)
        self.w17_entrys_6.grid(column=1, row=6)
        self.w17_entrys_6.delete(0, 'end')
        self.w17_entrys_6.insert(INSERT, self.BSLPW_S_6)

        self.w17_labels_7 = Label(w17_frames_0, text='224~255 bits:')
        self.w17_labels_7.grid(column=0, row=7)

        self.w17_entrys_7 = Entry(w17_frames_0, width=15)
        self.w17_entrys_7.grid(column=1, row=7)
        self.w17_entrys_7.delete(0, 'end')
        self.w17_entrys_7.insert(INSERT, self.BSLPW_S_7)

        self.w17_buttons_0 = Button(w17_frames_1, text='OK', command=self.BSLPW_OK)
        self.w17_buttons_0.pack()
    def BSLPW_OK(self):
        self.BSLPW_S_0 = self.w17_entrys_0.get()
        self.BSLPW_S_1 = self.w17_entrys_1.get()
        self.BSLPW_S_2 = self.w17_entrys_2.get()
        self.BSLPW_S_3 = self.w17_entrys_3.get()
        self.BSLPW_S_4 = self.w17_entrys_4.get()
        self.BSLPW_S_5 = self.w17_entrys_5.get()
        self.BSLPW_S_6 = self.w17_entrys_6.get()
        self.BSLPW_S_7 = self.w17_entrys_7.get()
        self.non_textlogsub.config(state=NORMAL)
        if len(self.BSLPW_S_0 + self.BSLPW_S_1 + self.BSLPW_S_2 + self.BSLPW_S_3 + self.BSLPW_S_4 + self.BSLPW_S_5 + \
               self.BSLPW_S_6 + self.BSLPW_S_7) != 80:
            self.BSLPW_S_0 = '0xFFFFFFFF'
            self.BSLPW_S_1 = '0xFFFFFFFF'
            self.BSLPW_S_2 = '0xFFFFFFFF'
            self.BSLPW_S_3 = '0xFFFFFFFF'
            self.BSLPW_S_4 = '0xFFFFFFFF'
            self.BSLPW_S_5 = '0xFFFFFFFF'
            self.BSLPW_S_6 = '0xFFFFFFFF'
            self.BSLPW_S_7 = '0xFFFFFFFF'
            self.non_textlogsub.insert(INSERT, 'Input length of BSLPW is invalid.\n', 'errors')
        else:
            try:
                return_value = int(self.BSLPW_S_0, 16)
                return_value = int(self.BSLPW_S_1, 16)
                return_value = int(self.BSLPW_S_2, 16)
                return_value = int(self.BSLPW_S_3, 16)
                return_value = int(self.BSLPW_S_4, 16)
                return_value = int(self.BSLPW_S_5, 16)
                return_value = int(self.BSLPW_S_6, 16)
                return_value = int(self.BSLPW_S_7, 16)
                self.non_textlogsub.insert(INSERT, 'BSLPW configuration finished.\n')
            except:
                self.BSLPW_S_0 = '0xFFFFFFFF'
                self.BSLPW_S_1 = '0xFFFFFFFF'
                self.BSLPW_S_2 = '0xFFFFFFFF'
                self.BSLPW_S_3 = '0xFFFFFFFF'
                self.BSLPW_S_4 = '0xFFFFFFFF'
                self.BSLPW_S_5 = '0xFFFFFFFF'
                self.BSLPW_S_6 = '0xFFFFFFFF'
                self.BSLPW_S_7 = '0xFFFFFFFF'
                self.non_textlogsub.insert(INSERT, 'Input value of BSLPW is invalid.\n', 'errors')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
    def BSLPLUGINCFG_call(self):
        sub_win18 = Toplevel(root)
        sub_win18.title('BSLPLUGINCFG')
        #        sub_win.attributes("-topmost", True)
        sub_win18.geometry("850x220+400+500")
        sub_win18.grab_set()
        w18_frames_0 = Frame(sub_win18)
        w18_frames_0.pack(padx=10, pady=10, anchor=W)
        w18_frames_1 = Frame(sub_win18)
        w18_frames_1.pack(padx=400, pady=20, anchor=W)

        self.w18_labels_0_0 = Label(w18_frames_0, text='SRAMEXISTS')
        self.w18_labels_0_0.grid(column=0, row=0, sticky='w')
        self.w18_labels_2_0 = Label(w18_frames_0, text=' SRAM consumed by Flash plugin, from 0x00 to 255.')
        self.w18_labels_2_0.grid(column=0, row=1, sticky='w')
        self.w18_entrys_0 = Entry(w18_frames_0, width=15)
        self.w18_entrys_0.grid(column=1, row=1)
        self.w18_entrys_0.delete(0, 'end')
        self.w18_entrys_0.insert(INSERT, self.BSLPLUGINCFG_var3)

        self.w18_labels_0 = Label(w18_frames_0, text='PLUGINEXISTS')
        self.w18_labels_0.grid(column=0, row=2, sticky='w')
        self.w18_labels_2 = Label(w18_frames_0, text='The field tells if Flash Plugin exists are not.'
                                                     ' 0xBB - Flash Plugin exists; 0xFF (all other values) - Only ROM plugins will be used.')
        self.w18_labels_2.grid(column=0, row=3, sticky='w')
        self.w18_comboExample = ttk.Combobox(w18_frames_0,
                                    values=[
                                        "exist",
                                        "not exist",],state= 'readonly')
        self.w18_comboExample.set(self.BSLPLUGINCFG_var1)
        self.w18_comboExample.grid(column=1, row=3, sticky='w')

        self.w18_labels_3 = Label(w18_frames_0, text='PLUGINTYPE')
        self.w18_labels_3.grid(column=0, row=4, sticky='w')
        self.w18_labels_4 = Label(w18_frames_0, text='The type code for the BSL plug-in.'
                                                     '(0x1000: UART.0x2000: I2C.0xFFFF: none)')
        self.w18_labels_4.grid(column=0, row=5, sticky='w')
        self.w18_comboExample1 = ttk.Combobox(w18_frames_0,
                                    values=[
                                        "UART",
                                        "I2C",
                                        "none",],state= 'readonly')
        self.w18_comboExample1.set(self.BSLPLUGINCFG_var2)
        self.w18_comboExample1.grid(column=1, row=5, sticky='w')

        self.w18_buttons1 = Button(w18_frames_1, text='OK', command=self.BSLPLUGINCFG_OK)
        self.w18_buttons1.pack()
    def BSLPLUGINCFG_OK(self):
        self.BSLPLUGINCFG_var1 = self.w18_comboExample.get()
        self.BSLPLUGINCFG_var2 = self.w18_comboExample1.get()
        self.BSLPLUGINCFG_var3 = self.w18_entrys_0.get()
        self.non_textlogsub.config(state=NORMAL)
        try:
            gg = hex(int(self.BSLPLUGINCFG_var3))
            ggtr = str(hex(int(gg, 16))).upper()
            if len(ggtr) == 3:
                ggtr = '0x0' + ggtr[2]
            if len(ggtr) == 4:
                self.BSLPLUGINCFG_var = '0x' + ggtr[2:] + self.BSLPLUGINCFG_var[4:]
            else:
                self.non_textlogsub.insert(INSERT, 'SRAMEXISTS input value invalid in BSLPLUGINCFG.\n', 'errors')
                self.BSLPLUGINCFG_var3 = '255'
            if self.BSLPLUGINCFG_var1 == 'exist':
                self.BSLPLUGINCFG_var = self.BSLPLUGINCFG_var[:4] + 'BB' + self.BSLPLUGINCFG_var[6:]
            else:
                self.BSLPLUGINCFG_var = self.BSLPLUGINCFG_var[:4] + 'FF' + self.BSLPLUGINCFG_var[6:]
            if self.BSLPLUGINCFG_var2 == 'UART':
                self.BSLPLUGINCFG_var = self.BSLPLUGINCFG_var[:6] + '1000'
            else:
                if self.BSLPLUGINCFG_var2 == 'I2C':
                    self.BSLPLUGINCFG_var = self.BSLPLUGINCFG_var[:6] + '2000'
                else:
                    self.BSLPLUGINCFG_var = self.BSLPLUGINCFG_var[:6] + 'FFFF'
            self.w2_entrys16['state'] = 'normal'
            self.w2_entrys16.delete(0, 'end')
            self.w2_entrys16.insert(INSERT, self.BSLPLUGINCFG_var)
            self.w2_entrys16['state'] = 'readonly'
            self.non_textlogsub.config(state=NORMAL)
            self.non_textlogsub.insert(INSERT, 'BSLPLUGINCFG configuration finished.\n')

        except :
            self.non_textlogsub.insert(INSERT, 'SRAMEXISTS input value invalid in BSLPLUGINCFG.\n', 'errors')
            self.BSLPLUGINCFG_var3 = '255'

        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
    def input_BSLPLUGINHOOK(self):
        sub_win19 = Toplevel(root)
        sub_win19.title('BSLPLUGINHOOK Configure')
        #        sub_win.attributes("-topmost", True)
        sub_win19.geometry("300x150+400+500")
        sub_win19.grab_set()
        w19_frames_0 = Frame(sub_win19)
        w19_frames_0.pack(padx=10, pady=10, anchor=W)
        w19_frames_1 = Frame(sub_win19)
        w19_frames_1.pack(padx=80, pady=10, anchor=W)
        self.w19_labels_0 = Label(w19_frames_0, text='Plugin init:')
        self.w19_labels_0.grid(column=0, row=0)

        self.w19_entrys_0 = Entry(w19_frames_0, width=15)
        self.w19_entrys_0.grid(column=1, row=0)
        self.w19_entrys_0.delete(0, 'end')
        self.w19_entrys_0.insert(INSERT, self.PLUGIN_INIT)

        self.w19_labels_1 = Label(w19_frames_0, text='Plugin receive:')
        self.w19_labels_1.grid(column=0, row=1)

        self.w19_entrys_1 = Entry(w19_frames_0, width=15)
        self.w19_entrys_1.grid(column=1, row=1)
        self.w19_entrys_1.delete(0, 'end')
        self.w19_entrys_1.insert(INSERT, self.PLUGIN_RECEIVE)

        self.w19_labels_2 = Label(w19_frames_0, text='Plugin transmit:')
        self.w19_labels_2.grid(column=0, row=2)

        self.w19_entrys_2 = Entry(w19_frames_0, width=15)
        self.w19_entrys_2.grid(column=1, row=2)
        self.w19_entrys_2.delete(0, 'end')
        self.w19_entrys_2.insert(INSERT, self.PLUGIN_TRANSMIT)

        self.w19_labels_3 = Label(w19_frames_0, text='Plugin de-init:')
        self.w19_labels_3.grid(column=0, row=3)

        self.w19_entrys_3 = Entry(w19_frames_0, width=15)
        self.w19_entrys_3.grid(column=1, row=3)
        self.w19_entrys_3.delete(0, 'end')
        self.w19_entrys_3.insert(INSERT, self.PLUGIN_DEINIT)

        self.w19_buttons_0 = Button(w19_frames_1, text='OK', command=self.BSLPLUGINHOOK_OK)
        self.w19_buttons_0.pack()
    def BSLPLUGINHOOK_OK(self):
        self.PLUGIN_INIT = self.w19_entrys_0.get()
        self.PLUGIN_RECEIVE = self.w19_entrys_1.get()
        self.PLUGIN_TRANSMIT = self.w19_entrys_2.get()
        self.PLUGIN_DEINIT = self.w19_entrys_3.get()
        self.non_textlogsub.config(state=NORMAL)
        if len(self.PLUGIN_INIT + self.PLUGIN_RECEIVE + self.PLUGIN_TRANSMIT + self.PLUGIN_DEINIT) != 40:
            self.PLUGIN_INIT = '0xFFFFFFFF'
            self.PLUGIN_RECEIVE = '0xFFFFFFFF'
            self.PLUGIN_TRANSMIT = '0xFFFFFFFF'
            self.PLUGIN_DEINIT = '0xFFFFFFFF'
            self.non_textlogsub.insert(INSERT, 'Input length of BSLPLUGINHOOK is invalid.\n', 'errors')
        else:
            try:
                return_value = int(self.PLUGIN_INIT, 16)
                return_value = int(self.PLUGIN_RECEIVE, 16)
                return_value = int(self.PLUGIN_TRANSMIT, 16)
                return_value = int(self.PLUGIN_DEINIT, 16)
                self.non_textlogsub.insert(INSERT, 'BSLPLUGINHOOK configuration finished.\n')
            except:
                self.PLUGIN_INIT = '0xFFFFFFFF'
                self.PLUGIN_RECEIVE = '0xFFFFFFFF'
                self.PLUGIN_TRANSMIT = '0xFFFFFFFF'
                self.PLUGIN_DEINIT = '0xFFFFFFFF'
                self.non_textlogsub.insert(INSERT, 'Input value of BSLPLUGINHOOK is invalid.\n', 'errors')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
    def BSLALTCFG_call(self):
        sub_win20 = Toplevel(root)
        sub_win20.title('PATCHHOOKID')
        #        sub_win.attributes("-topmost", True)
        sub_win20.geometry("700x200+400+500")
        sub_win20.grab_set()
        w20_frames_0 = Frame(sub_win20)
        w20_frames_0.pack(padx=10, pady=10, anchor=W)
        w20_frames_1 = Frame(sub_win20)
        w20_frames_1.pack(padx=300, pady=20, anchor=W)
        self.w20_labels_0 = Label(w20_frames_0, text='ID')
        self.w20_labels_0.grid(column=0, row=0, sticky='w')
        self.w20_labels_2 = Label(w20_frames_0, text='Alternate BSL configuration. ID field to invoke an alternate BSL.\n'
                                  '0xAABB:Use the alternate BSL; Other value:Do not use the alternate BSL')
        self.w20_labels_2.grid(column=0, row=1, sticky='w')
        self.w20_comboExample = ttk.Combobox(w20_frames_0,
                                    values=[
                                        "use",
                                        "not use",],state= 'readonly')
        self.w20_comboExample.set(self.BSLALTCFG_var1)
        self.w20_comboExample.grid(column=1, row=1, sticky='w')

        self.w20_buttons1 = Button(w20_frames_1, text='OK', command=self.BSLALTCFG_OK)
        self.w20_buttons1.pack()
    def BSLALTCFG_OK(self):
        self.BSLALTCFG_var1 = self.w20_comboExample.get()
        if self.BSLALTCFG_var1 == 'use':
            self.BSLALTCFG_var = '0xFFFFAABB'
        else:
            self.BSLALTCFG_var = '0xFFFFFFFF'
        self.w2_entrys18['state'] = 'normal'
        self.w2_entrys18.delete(0, 'end')
        self.w2_entrys18.insert(INSERT, self.BSLALTCFG_var)
        self.w2_entrys18['state'] = 'readonly'
        self.non_textlogsub.config(state=NORMAL)
        self.non_textlogsub.insert(INSERT, 'BSLALTCFG configuration finished.\n')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
    def BSLALTADDR_call(self):
        sub_win21 = Toplevel(root)
        sub_win21.title('BSLALTADDR')
        #        sub_win.attributes("-topmost", True)
        sub_win21.geometry("500x100+400+500")
        sub_win21.grab_set()
        w21_frames_0 = Frame(sub_win21)
        w21_frames_0.pack(padx=10, pady=10, anchor=W)
        w21_frames_1 = Frame(sub_win21)
        w21_frames_1.pack(padx=200, pady=10, anchor=W)
        self.w21_labels_2 = Label(w21_frames_0, text='Entry address of the alternate BSL(must be an address in a MAIN flash region).')
        self.w21_labels_2.grid(column=0, row=1, sticky='w')

        self.w21_entrys_0 = Entry(w21_frames_0, width=15)
        self.w21_entrys_0.grid(column=0, row=2)
        self.w21_entrys_0.delete(0, 'end')
        self.w21_entrys_0.insert(INSERT, self.BSLALTADDR_var)

        self.w21_buttons1 = Button(w21_frames_1, text='OK', command=self.BSLALTADDR_OK)
        self.w21_buttons1.pack()
    def BSLALTADDR_OK(self):
        self.BSLALTADDR_var = self.w21_entrys_0.get()
        self.non_textlogsub.config(state=NORMAL)
        if len(self.BSLALTADDR_var) != 10:
            self.BSLALTADDR_var = '0xFFFFFFFF'
            self.non_textlogsub.insert(INSERT, 'Input length of BSLALTADDR is invalid.\n', 'errors')
        else:
            try:
                return_value = int(self.BSLALTADDR_var, 16)
                self.non_textlogsub.insert(INSERT, 'BSLALTADDR configuration finished.\n')
            except:
                self.BSLALTADDR_var = '0xFFFFFFFF'
                self.non_textlogsub.insert(INSERT, 'Input value of BSLALTADDR is invalid.\n', 'errors')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
        self.w2_entrys19['state'] = 'normal'
        self.w2_entrys19.delete(0, 'end')
        self.w2_entrys19.insert(INSERT, self.BSLALTADDR_var)
        self.w2_entrys19['state'] = 'readonly'

    def BSLAPPVER_call(self):
        sub_win22 = Toplevel(root)
        sub_win22.title('BSLAPPVER')
        #        sub_win.attributes("-topmost", True)
        sub_win22.geometry("500x100+400+500")
        sub_win22.grab_set()
        w22_frames_0 = Frame(sub_win22)
        w22_frames_0.pack(padx=10, pady=10, anchor=W)
        w22_frames_1 = Frame(sub_win22)
        w22_frames_1.pack(padx=200, pady=10, anchor=W)
        self.w22_labels_2 = Label(w22_frames_0, text='Address of the application version word.')
        self.w22_labels_2.grid(column=0, row=1, sticky='w')

        self.w22_entrys_0 = Entry(w22_frames_0, width=15)
        self.w22_entrys_0.grid(column=0, row=2)
        self.w22_entrys_0.delete(0, 'end')
        self.w22_entrys_0.insert(INSERT, self.BSLAPPVER_var)

        self.w22_buttons1 = Button(w22_frames_1, text='OK', command=self.BSLAPPVER_OK)
        self.w22_buttons1.pack()
    def BSLAPPVER_OK(self):
        self.BSLAPPVER_var = self.w22_entrys_0.get()
        self.non_textlogsub.config(state=NORMAL)
        if len(self.BSLAPPVER_var) != 10:
            self.BSLAPPVER_var = '0xFFFFFFFF'
            self.non_textlogsub.insert(INSERT, 'Input length of BSLAPPVER is invalid.\n', 'errors')
        else:
            try:
                return_value = int(self.BSLAPPVER_var, 16)
                self.non_textlogsub.insert(INSERT, 'BSLAPPVER configuration finished.\n')
            except:
                self.BSLAPPVER_var = '0xFFFFFFFF'
                self.non_textlogsub.insert(INSERT, 'Input value of BSLAPPVER is invalid.\n', 'errors')
        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
        self.w2_entrys20['state'] = 'normal'
        self.w2_entrys20.delete(0, 'end')
        self.w2_entrys20.insert(INSERT, self.BSLAPPVER_var)
        self.w2_entrys20['state'] = 'readonly'

    def BSLSECCFG_call(self):
        sub_win23 = Toplevel(root)
        sub_win23.title('BSLCONFIG1')
        #        sub_win.attributes("-topmost", True)
        sub_win23.geometry("600x200+400+500")
        sub_win23.grab_set()
        w23_frames_0 = Frame(sub_win23)
        w23_frames_0.pack(padx=10, pady=10, anchor=W)
        w23_frames_1 = Frame(sub_win23)
        w23_frames_1.pack(padx=200, pady=20, anchor=W)

        self.w23_labels_0_0 = Label(w23_frames_0, text='TARGETADDR')
        self.w23_labels_0_0.grid(column=0, row=0, sticky='w')
        self.w23_labels_2_0 = Label(w23_frames_0, text=' I2C target address to be used for the BSL I2C communication.')
        self.w23_labels_2_0.grid(column=0, row=1, sticky='w')
        self.w23_entrys_0 = Entry(w23_frames_0, width=15)
        self.w23_entrys_0.grid(column=1, row=1)
        self.w23_entrys_0.delete(0, 'end')
        self.w23_entrys_0.insert(INSERT, self.BSLSECCFG_var2)

        self.w23_labels_0 = Label(w23_frames_0, text='ALERTACTION')
        self.w23_labels_0.grid(column=0, row=2, sticky='w')
        self.w23_labels_2 = Label(w23_frames_0, text='Action to take upon a security alert condition.\n'
            '0xAABB:Trigger a factory reset; 0xCCDD:disable the BSL;\nOther value:Ignore the security alert condition')
        self.w23_labels_2.grid(column=0, row=3, sticky='W')
        self.w23_comboExample = ttk.Combobox(w23_frames_0,
                                    values=[
                                        "Trigger a factory reset",
                                        "disable the BSL",
                                        "ignore",],state= 'readonly')
        self.w23_comboExample.set(self.BSLSECCFG_var1)
        self.w23_comboExample.grid(column=1, row=3, sticky='w')

        self.w23_buttons1 = Button(w23_frames_1, text='OK', command=self.BSLSECCFG_OK)
        self.w23_buttons1.pack()
    def BSLSECCFG_OK(self):
        self.BSLSECCFG_var1 = self.w23_comboExample.get()
        self.BSLSECCFG_var2 = self.w23_entrys_0.get()

        try:
            gg = hex(int(self.BSLSECCFG_var2))
            ggtr = gg.upper()
            while len(ggtr) <= 5:
                ggtr = '0x0' + ggtr[2:]
            if len(ggtr) == 6:
                self.BSLSECCFG_var = '0x' + ggtr[2:] + self.BSLSECCFG_var[6:]
            else:
                self.non_textlogsub.insert(INSERT, 'TARGETADDR input value invalid in BSLCONFIG1.\n', 'errors')
                self.BSLSECCFG_var2 = '72'

            if self.BSLSECCFG_var1 == 'Trigger a factory reset':
                self.BSLSECCFG_var = self.BSLSECCFG_var[:6] + 'AABB'
            else:
                if self.BSLSECCFG_var1 == 'disable the BSL':
                    self.BSLSECCFG_var = self.BSLSECCFG_var[:6] + 'CCDD'
                else:
                    self.BSLSECCFG_var = self.BSLSECCFG_var[:6] + 'FFFF'
            self.w2_entrys21['state'] = 'normal'
            self.w2_entrys21.delete(0, 'end')
            self.w2_entrys21.insert(INSERT, self.BSLSECCFG_var)
            self.w2_entrys21['state'] = 'readonly'
            self.non_textlogsub.config(state=NORMAL)
            self.non_textlogsub.insert(INSERT, 'BSLCONFIG1 configuration finished.\n')
        except :
            self.non_textlogsub.insert(INSERT, 'TARGETADDR input value invalid in BSLCONFIG1.\n', 'errors')
            self.BSLSECCFG_var2 = '72'

        self.non_textlogsub.see(END)
        self.non_textlogsub.config(state=DISABLED)
    def Generate_call(self):
        self.non_textlogsub.config(state=NORMAL)
        BCRCONFIGID_var_b =  bytearray.fromhex(self.BCRCONFIGID_var[2:])
        BCRCONFIGID_var_b.reverse()
        BOOTCFG0_var_b =  bytearray.fromhex(self.BOOTCFG0_var[2:])
        BOOTCFG0_var_b.reverse()
        BOOTCFG1_var_b =  bytearray.fromhex(self.BOOTCFG1_var[2:])
        BOOTCFG1_var_b.reverse()
        SWDPW_S_0_b = bytearray.fromhex(self.SWDPW_S_0[2:])
        SWDPW_S_0_b.reverse()
        SWDPW_S_1_b = bytearray.fromhex(self.SWDPW_S_1[2:])
        SWDPW_S_1_b.reverse()
        SWDPW_S_2_b = bytearray.fromhex(self.SWDPW_S_2[2:])
        SWDPW_S_2_b.reverse()
        SWDPW_S_3_b = bytearray.fromhex(self.SWDPW_S_3[2:])
        SWDPW_S_3_b.reverse()
        BOOTCFG2_var_b = bytearray.fromhex(self.BOOTCFG2_var[2:])
        BOOTCFG2_var_b.reverse()
        BOOTCFG3_var_b = bytearray.fromhex(self.BOOTCFG3_var[2:])
        BOOTCFG3_var_b.reverse()
        MEPW_S_0_b = bytearray.fromhex(self.MEPW_S_0[2:])
        MEPW_S_0_b.reverse()
        MEPW_S_1_b = bytearray.fromhex(self.MEPW_S_1[2:])
        MEPW_S_1_b.reverse()
        MEPW_S_2_b = bytearray.fromhex(self.MEPW_S_2[2:])
        MEPW_S_2_b.reverse()
        MEPW_S_3_b = bytearray.fromhex(self.MEPW_S_3[2:])
        MEPW_S_3_b.reverse()
        FRPW_S_0_b = bytearray.fromhex(self.FRPW_S_0[2:])
        FRPW_S_0_b.reverse()
        FRPW_S_1_b = bytearray.fromhex(self.FRPW_S_1[2:])
        FRPW_S_1_b.reverse()
        FRPW_S_2_b = bytearray.fromhex(self.FRPW_S_2[2:])
        FRPW_S_2_b.reverse()
        FRPW_S_3_b = bytearray.fromhex(self.FRPW_S_3[2:])
        FRPW_S_3_b.reverse()
        FLASHSWP0_var_b = bytearray.fromhex(self.FLASHSWP0_var[2:])
        FLASHSWP0_var_b.reverse()
        FLASHSWP1_var_b = bytearray.fromhex(self.FLASHSWP1_var[2:])
        FLASHSWP1_var_b.reverse()
        BOOTCFG4_var_b = bytearray.fromhex(self.BOOTCFG4_var[2:])
        BOOTCFG4_var_b.reverse()
        APPCRCSTART_var_b = bytearray.fromhex(self.APPCRCSTART_var[2:])
        APPCRCSTART_var_b.reverse()
        APPCRCLEN_var_b = bytearray.fromhex(self.APPCRCLEN_var[2:])
        APPCRCLEN_var_b.reverse()
        APPCRC_var_b = bytearray.fromhex(self.APPCRC_var[2:])
        APPCRC_var_b.reverse()
        BC_CONFIG_b  = BCRCONFIGID_var_b + BOOTCFG0_var_b +BOOTCFG1_var_b + SWDPW_S_0_b + SWDPW_S_1_b + SWDPW_S_2_b + SWDPW_S_3_b + BOOTCFG2_var_b + BOOTCFG3_var_b \
                        + MEPW_S_0_b + MEPW_S_1_b + MEPW_S_2_b + MEPW_S_3_b + FRPW_S_0_b + FRPW_S_1_b + FRPW_S_2_b + FRPW_S_3_b\
                       + FLASHSWP0_var_b + FLASHSWP1_var_b + BOOTCFG4_var_b + APPCRCSTART_var_b + APPCRCLEN_var_b + APPCRC_var_b
        # print(BC_CONFIG_b)
        BC_CONFIG_CRC = self.crc32(BC_CONFIG_b)
        # print('%x' %BC_CONFIG_CRC)
        BC_CONFIG_CRC_str = hex(BC_CONFIG_CRC)
        counter_buf = 2
        # print(BSL_CONFIG_CRC_str[:counter_buf])
        while len(BC_CONFIG_CRC_str) < 10:
            BC_CONFIG_CRC_str = BC_CONFIG_CRC_str[:counter_buf] + '0' + BC_CONFIG_CRC_str[counter_buf:]
            counter_buf += 1
        BC_CONFIG_CRC_b = bytearray.fromhex(BC_CONFIG_CRC_str[2:])
        BC_CONFIG_CRC_b.reverse()
        BC_CONFIG_b += BC_CONFIG_CRC_b

        BSLID_var_b =  bytearray.fromhex(self.BSLID_var[2:])
        BSLID_var_b.reverse()
        BSL_CONFIG_b = BSLID_var_b
        BSLPINCFG0_var_b =  bytearray.fromhex(self.BSLPINCFG0_var[2:])
        BSLPINCFG0_var_b.reverse()
        BSL_CONFIG_b += BSLPINCFG0_var_b
        BSLPINCFG1_var_b =  bytearray.fromhex(self.BSLPINCFG1_var[2:])
        BSLPINCFG1_var_b.reverse()
        BSL_CONFIG_b += BSLPINCFG1_var_b
        BSLCFG_var_b =  bytearray.fromhex(self.BSLCFG_var[2:])
        BSLCFG_var_b.reverse()
        BSL_CONFIG_b += BSLCFG_var_b
        BSLPW_S_0_var_b =  bytearray.fromhex(self.BSLPW_S_0[2:])
        BSLPW_S_0_var_b.reverse()
        BSL_CONFIG_b += BSLPW_S_0_var_b
        BSL_PASSWORD_b = BSLPW_S_0_var_b
        BSLPW_S_1_var_b =  bytearray.fromhex(self.BSLPW_S_1[2:])
        BSLPW_S_1_var_b.reverse()
        BSL_CONFIG_b += BSLPW_S_1_var_b
        BSL_PASSWORD_b += BSLPW_S_1_var_b
        BSLPW_S_2_var_b =  bytearray.fromhex(self.BSLPW_S_2[2:])
        BSLPW_S_2_var_b.reverse()
        BSL_CONFIG_b += BSLPW_S_2_var_b
        BSL_PASSWORD_b += BSLPW_S_2_var_b
        BSLPW_S_3_var_b =  bytearray.fromhex(self.BSLPW_S_3[2:])
        BSLPW_S_3_var_b.reverse()
        BSL_CONFIG_b += BSLPW_S_3_var_b
        BSL_PASSWORD_b += BSLPW_S_3_var_b
        BSLPW_S_4_var_b =  bytearray.fromhex(self.BSLPW_S_4[2:])
        BSLPW_S_4_var_b.reverse()
        BSL_CONFIG_b += BSLPW_S_4_var_b
        BSL_PASSWORD_b += BSLPW_S_4_var_b
        BSLPW_S_5_var_b =  bytearray.fromhex(self.BSLPW_S_5[2:])
        BSLPW_S_5_var_b.reverse()
        BSL_CONFIG_b += BSLPW_S_5_var_b
        BSL_PASSWORD_b += BSLPW_S_5_var_b
        BSLPW_S_6_var_b =  bytearray.fromhex(self.BSLPW_S_6[2:])
        BSLPW_S_6_var_b.reverse()
        BSL_CONFIG_b += BSLPW_S_6_var_b
        BSL_PASSWORD_b += BSLPW_S_6_var_b
        BSLPW_S_7_var_b =  bytearray.fromhex(self.BSLPW_S_7[2:])
        BSLPW_S_7_var_b.reverse()
        BSL_CONFIG_b += BSLPW_S_7_var_b
        BSL_PASSWORD_b += BSLPW_S_7_var_b
        BSLPLUGINCFG_var_b =  bytearray.fromhex(self.BSLPLUGINCFG_var[2:])
        BSLPLUGINCFG_var_b.reverse()
        BSL_CONFIG_b += BSLPLUGINCFG_var_b
        PLUGIN_INIT_b =  bytearray.fromhex(self.PLUGIN_INIT[2:])
        PLUGIN_INIT_b.reverse()
        BSL_CONFIG_b += PLUGIN_INIT_b
        PLUGIN_RECEIVE_b =  bytearray.fromhex(self.PLUGIN_RECEIVE[2:])
        PLUGIN_RECEIVE_b.reverse()
        BSL_CONFIG_b += PLUGIN_RECEIVE_b
        PLUGIN_TRANSMIT_b =  bytearray.fromhex(self.PLUGIN_TRANSMIT[2:])
        PLUGIN_TRANSMIT_b.reverse()
        BSL_CONFIG_b += PLUGIN_TRANSMIT_b
        PLUGIN_DEINIT_b =  bytearray.fromhex(self.PLUGIN_DEINIT[2:])
        PLUGIN_DEINIT_b.reverse()
        BSL_CONFIG_b += PLUGIN_DEINIT_b
        BSLALTCFG_var_b =  bytearray.fromhex(self.BSLALTCFG_var[2:])
        BSLALTCFG_var_b.reverse()
        BSL_CONFIG_b += BSLALTCFG_var_b
        BSLALTADDR_var_b =  bytearray.fromhex(self.BSLALTADDR_var[2:])
        BSLALTADDR_var_b.reverse()
        # print(BSLALTADDR_var_b)
        BSL_CONFIG_b += BSLALTADDR_var_b
        BSLAPPVER_var_b =  bytearray.fromhex(self.BSLAPPVER_var[2:])
        BSLAPPVER_var_b.reverse()
        BSL_CONFIG_b += BSLAPPVER_var_b
        BSLSECCFG_var_b =  bytearray.fromhex(self.BSLSECCFG_var[2:])
        BSLSECCFG_var_b.reverse()
        BSL_CONFIG_b += BSLSECCFG_var_b

        BSL_CONFIG_CRC = self.crc32(BSL_CONFIG_b)
        # print('%x' %BSL_CONFIG_CRC)
        BSL_CONFIG_CRC_str = hex(BSL_CONFIG_CRC)
        # print(len(BSL_CONFIG_CRC_str))
        counter_buf = 2
        # print(BSL_CONFIG_CRC_str[:counter_buf])
        while len(BSL_CONFIG_CRC_str) < 10:
            BSL_CONFIG_CRC_str = BSL_CONFIG_CRC_str[:counter_buf] + '0' + BSL_CONFIG_CRC_str[counter_buf:]
            counter_buf += 1
        # print(type(BSL_CONFIG_CRC_str))
        # print(BSL_CONFIG_CRC_str)
        BSL_CONFIG_CRC_b = bytearray.fromhex(BSL_CONFIG_CRC_str[2:])
        BSL_CONFIG_CRC_b.reverse()
        BSL_CONFIG_b += BSL_CONFIG_CRC_b

        self.version_var = self.w2_entrys22.get()
        filename_non_main = "Output/Non_main_flash_firmware_"+self.version_var +".txt"
        filename_bsl_password = "Output/BSL_Password_"+self.version_var +".txt"
        file_write_count = 0
        with open(filename_non_main, 'w+') as non_main_file_write:
            non_main_file_write.write('@41c00000\n')
            for b in BC_CONFIG_b:
                h=hex(b)
                str0=str(h)
                str0 = str0.upper()
                if file_write_count == 15:
                    if len(str0) == 3:
                        non_main_file_write.write('0' + str0[2:] + '\n')
                    else:
                        non_main_file_write.write(str0[2:] + '\n')
                    file_write_count = 0
                    continue
                if len(str0) == 3:
                    non_main_file_write.write('0' + str0[2:] + ' ')
                else:
                    non_main_file_write.write(str0[2:] + ' ')
                file_write_count +=1
            file_write_count = 0
            non_main_file_write.write('@41c00100\n')
            for b in BSL_CONFIG_b:
                h=hex(b)
                str0=str(h)
                str0 = str0.upper()
                if file_write_count == 15:
                    if len(str0) == 3:
                        non_main_file_write.write('0' + str0[2:] + '\n')
                    else:
                        non_main_file_write.write(str0[2:] + '\n')
                    file_write_count = 0
                    continue
                if len(str0) == 3:
                    non_main_file_write.write('0' + str0[2:] + ' ')
                else:
                    non_main_file_write.write(str0[2:] + ' ')
                file_write_count +=1
            non_main_file_write.write("\n")
            non_main_file_write.write("q\n")
            file_write_count = 0
            with open(filename_bsl_password, 'w+') as password_file_write:
                password_file_write.write('@password\n')
                for b in BSL_PASSWORD_b:
                    h = hex(b)
                    str0 = str(h)
                    str0 = str0.upper()
                    if file_write_count == 15:
                        if len(str0) == 3:
                            password_file_write.write('0' + str0[2:] + '\n')
                        else:
                            password_file_write.write(str0[2:] + '\n')
                        file_write_count = 0
                        continue
                    if len(str0) == 3:
                        password_file_write.write('0' + str0[2:] + ' ')
                    else:
                        password_file_write.write(str0[2:] + ' ')
                    file_write_count += 1
                password_file_write.write("q\n")


            self.non_textlogsub.insert(INSERT, '-----Generate Non_main_flash_firmware_' + self.version_var + '.txt -----\n', 'pass_s')
            self.non_textlogsub.insert(INSERT,
                                       '-----Generate BSL_Password_' + self.version_var + '.txt -----\n', 'pass_s')
            self.non_textlogsub.see(END)
            self.non_textlogsub.config(state=DISABLED)

    def crc32(self, data_B):
        crc = 0xFFFFFFFF
        crc32_POLY = 0xEDB88320
        for b in data_B:
            crc = crc ^ b
            ii = 1
            while ii<=8:
                mask = -(crc & 1)
                crc = (crc >> 1) ^ (crc32_POLY & mask)
                ii+=1
        return crc


if __name__ == '__main__':
    file_d = Get_files()
    BSL_pack = BSL_Pack()
    UART_S = UART_send()
    Linker_g = Generate_link()
    Conver_F = TXT_to_h()
    root = Tk()
    root.iconbitmap('imag/Capture.ico')
    root.geometry("700x580+500+500")
    root.title("MSPM0 Live Firmware Update Bootloader GUI")
    root.configure(bg = '#A8B680')
    app = Tkinter_app(root)
    root.mainloop();